/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.concurrency.WorkQueue;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import nonapi.io.github.classgraph.utils.LogNode;

class ClasspathElementDir
extends ClasspathElement {
    private final File classpathEltDir;
    private int ignorePrefixLen;
    private final HashSet<String> scannedCanonicalPaths = new HashSet();

    ClasspathElementDir(File classpathEltDir, ClassLoader[] classLoaders, ScanSpec scanSpec) {
        super(classLoaders, scanSpec);
        this.classpathEltDir = classpathEltDir;
        if (scanSpec.performScan) {
            this.ignorePrefixLen = classpathEltDir.getPath().length() + 1;
            this.whitelistedResources = new ArrayList();
            this.whitelistedClassfileResources = new ArrayList();
            this.fileToLastModified = new HashMap();
        }
    }

    @Override
    void open(WorkQueue<String> workQueue, LogNode log) {
        if (!this.scanSpec.scanDirs) {
            if (log != null) {
                log.log("Skipping classpath element, since dir scanning is disabled: " + this.classpathEltDir);
            }
            this.skipClasspathElement = true;
        }
    }

    private Resource newResource(final File classpathEltFile, final String relativePath, final File classpathResourceFile) {
        return new Resource(){
            private RandomAccessFile randomAccessFile;
            private FileChannel fileChannel;
            {
                this.length = classpathResourceFile.length();
            }

            @Override
            public String getPath() {
                return relativePath;
            }

            @Override
            public String getPathRelativeToClasspathElement() {
                return relativePath;
            }

            @Override
            public URL getURL() {
                try {
                    return new File(classpathEltFile, relativePath).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Could not form URL for dir: " + classpathEltFile + " ; path: " + relativePath);
                }
            }

            @Override
            public URL getClasspathElementURL() {
                try {
                    return this.getClasspathElementFile().toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public File getClasspathElementFile() {
                return ClasspathElementDir.this.classpathEltDir;
            }

            @Override
            public ModuleRef getModuleRef() {
                return null;
            }

            @Override
            public synchronized ByteBuffer read() throws IOException {
                if (ClasspathElementDir.this.skipClasspathElement) {
                    throw new IOException("Parent directory could not be opened");
                }
                this.markAsOpen();
                try {
                    this.randomAccessFile = new RandomAccessFile(classpathResourceFile, "r");
                    this.fileChannel = this.randomAccessFile.getChannel();
                    MappedByteBuffer buffer = null;
                    try {
                        buffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.fileChannel.size());
                    }
                    catch (FileNotFoundException e) {
                        throw e;
                    }
                    catch (IOException | OutOfMemoryError e) {
                        System.gc();
                        buffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.fileChannel.size());
                    }
                    this.byteBuffer = buffer;
                    this.length = this.byteBuffer.remaining();
                    return this.byteBuffer;
                }
                catch (Exception e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            synchronized InputStreamOrByteBufferAdapter openOrRead() throws IOException {
                if (this.length >= (long)FileUtils.FILECHANNEL_FILE_SIZE_THRESHOLD) {
                    return new InputStreamOrByteBufferAdapter(this.read());
                }
                this.inputStream = new Resource.InputStreamResourceCloser(this, new FileInputStream(classpathResourceFile));
                return new InputStreamOrByteBufferAdapter(this.inputStream);
            }

            @Override
            public synchronized InputStream open() throws IOException {
                if (this.length >= (long)FileUtils.FILECHANNEL_FILE_SIZE_THRESHOLD) {
                    this.read();
                    this.inputStream = new Resource.InputStreamResourceCloser(this, this.byteBufferToInputStream());
                    return this.inputStream;
                }
                this.markAsOpen();
                this.inputStream = new Resource.InputStreamResourceCloser(this, Files.newInputStream(classpathResourceFile.toPath(), new OpenOption[0]));
                return this.inputStream;
            }

            @Override
            public synchronized byte[] load() throws IOException {
                try {
                    byte[] byteArray;
                    if (this.length >= (long)FileUtils.FILECHANNEL_FILE_SIZE_THRESHOLD) {
                        this.read();
                        byteArray = this.byteBufferToByteArray();
                    } else {
                        this.open();
                        byteArray = FileUtils.readAllBytesAsArray(this.inputStream, this.length);
                    }
                    this.length = byteArray.length;
                    byte[] byArray = byteArray;
                    return byArray;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public synchronized void close() {
                if (this.inputStream != null) {
                    try {
                        InputStream inputStreamWrapper = this.inputStream;
                        this.inputStream = null;
                        inputStreamWrapper.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.fileChannel != null) {
                    try {
                        this.fileChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.fileChannel = null;
                }
                if (this.randomAccessFile != null) {
                    try {
                        this.randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.randomAccessFile = null;
                }
                FileUtils.closeDirectByteBuffer(this.byteBuffer, null);
                this.byteBuffer = null;
                this.markAsClosed();
            }
        };
    }

    @Override
    Resource getResource(String relativePath) {
        File resourceFile = new File(this.classpathEltDir, relativePath);
        return resourceFile.canRead() && resourceFile.isFile() ? this.newResource(this.classpathEltDir, relativePath, resourceFile) : null;
    }

    private void scanDirRecursively(File dir, LogNode log) {
        LogNode subLog;
        ScanSpec.ScanSpecPathMatch parentMatchStatus;
        String dirRelativePath;
        String canonicalPath;
        if (this.skipClasspathElement) {
            return;
        }
        try {
            canonicalPath = dir.getCanonicalPath();
            if (!this.scannedCanonicalPaths.add(canonicalPath)) {
                if (log != null) {
                    log.log("Reached symlink cycle, stopping recursion: " + dir);
                }
                return;
            }
        }
        catch (IOException | SecurityException e) {
            if (log != null) {
                log.log("Could not canonicalize path: " + dir, e);
            }
            return;
        }
        String dirPath = dir.getPath();
        String string = dirRelativePath = this.ignorePrefixLen > dirPath.length() ? "/" : dirPath.substring(this.ignorePrefixLen).replace(File.separatorChar, '/') + "/";
        if (this.nestedClasspathRootPrefixes != null && this.nestedClasspathRootPrefixes.contains(dirRelativePath)) {
            if (log != null) {
                log.log("Reached nested classpath root, stopping recursion to avoid duplicate scanning: " + dirRelativePath);
            }
            return;
        }
        if (!this.scanSpec.classpathElementResourcePathWhiteBlackList.whitelistAndBlacklistAreEmpty()) {
            if (this.scanSpec.classpathElementResourcePathWhiteBlackList.isBlacklisted(dirRelativePath)) {
                if (log != null) {
                    log.log("Reached blacklisted classpath element resource path, stopping scanning: " + dirRelativePath);
                }
                this.skipClasspathElement = true;
                return;
            }
            if (this.scanSpec.classpathElementResourcePathWhiteBlackList.isSpecificallyWhitelisted(dirRelativePath)) {
                if (log != null) {
                    log.log("Reached specifically whitelisted classpath element resource path: " + dirRelativePath);
                }
                this.containsSpecificallyWhitelistedClasspathElementResourcePath = true;
            }
        }
        if ((parentMatchStatus = this.scanSpec.dirWhitelistMatchStatus(dirRelativePath)) == ScanSpec.ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX) {
            if (log != null) {
                log.log("Reached blacklisted directory, stopping recursive scan: " + dirRelativePath);
            }
            return;
        }
        if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH) {
            return;
        }
        Object[] filesInDir = dir.listFiles();
        Arrays.sort(filesInDir);
        if (filesInDir == null) {
            if (log != null) {
                log.log("Invalid directory " + dir);
            }
            return;
        }
        LogNode logNode = log == null ? null : (subLog = log.log(canonicalPath, "Scanning directory: " + dir + (dir.getPath().equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath)));
        if (parentMatchStatus != ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) {
            for (Object fileInDir : filesInDir) {
                String fileInDirRelativePath;
                if (!((File)fileInDir).isFile()) continue;
                String string2 = fileInDirRelativePath = dirRelativePath.isEmpty() || "/".equals(dirRelativePath) ? ((File)fileInDir).getName() : dirRelativePath + ((File)fileInDir).getName();
                if (!this.scanSpec.classpathElementResourcePathWhiteBlackList.whitelistAndBlacklistAreEmpty()) {
                    if (this.scanSpec.classpathElementResourcePathWhiteBlackList.isBlacklisted(fileInDirRelativePath)) {
                        if (subLog != null) {
                            subLog.log("Reached blacklisted classpath element resource path, stopping scanning: " + fileInDirRelativePath);
                        }
                        this.skipClasspathElement = true;
                        return;
                    }
                    if (this.scanSpec.classpathElementResourcePathWhiteBlackList.isSpecificallyWhitelisted(fileInDirRelativePath)) {
                        if (subLog != null) {
                            subLog.log("Reached specifically whitelisted classpath element resource path: " + fileInDirRelativePath);
                        }
                        this.containsSpecificallyWhitelistedClasspathElementResourcePath = true;
                    }
                }
                if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_PATH || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE && this.scanSpec.classfileIsSpecificallyWhitelisted(fileInDirRelativePath)) {
                    Resource resource = this.newResource(this.classpathEltDir, fileInDirRelativePath, (File)fileInDir);
                    this.addWhitelistedResource(resource, parentMatchStatus, subLog);
                    this.fileToLastModified.put(fileInDir, ((File)fileInDir).lastModified());
                    continue;
                }
                if (subLog == null) continue;
                subLog.log("Skipping non-whitelisted file: " + fileInDirRelativePath);
            }
        }
        for (Object fileInDir : filesInDir) {
            if (!((File)fileInDir).isDirectory()) continue;
            this.scanDirRecursively((File)fileInDir, subLog);
            if (subLog != null) {
                subLog.addElapsedTime();
            }
            if (!this.skipClasspathElement) continue;
            return;
        }
        this.fileToLastModified.put(dir, dir.lastModified());
    }

    @Override
    void scanPaths(LogNode log) {
        if (this.skipClasspathElement) {
            return;
        }
        if (this.scanned.getAndSet(true)) {
            throw new IllegalArgumentException("Already scanned classpath element " + this.toString());
        }
        LogNode subLog = log == null ? null : log.log(this.classpathEltDir.getPath(), "Scanning directory classpath element " + this.classpathEltDir);
        this.scanDirRecursively(this.classpathEltDir, subLog);
        if (subLog != null) {
            subLog.addElapsedTime();
        }
    }

    public File getDirFile() {
        return this.classpathEltDir;
    }

    public String toString() {
        return this.classpathEltDir.toString();
    }
}

