/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.concurrency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import nonapi.io.github.classgraph.utils.LogNode;

public abstract class SingletonMap<K, V> {
    private final ConcurrentMap<K, SingletonHolder<V>> map = new ConcurrentHashMap<K, SingletonHolder<V>>();
    private final ConcurrentLinkedQueue<SingletonHolder<V>> singletonHolderRecycler = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createSingleton(K key, LogNode log) throws Exception {
        SingletonHolder<V> oldSingletonHolder;
        SingletonHolder<Object> newSingletonHolder = this.singletonHolderRecycler.poll();
        if (newSingletonHolder == null) {
            newSingletonHolder = new SingletonHolder();
        }
        if ((oldSingletonHolder = this.map.putIfAbsent(key, newSingletonHolder)) == null) {
            Object newInstance = null;
            try {
                newInstance = this.newInstance(key, log);
                if (newInstance == null) {
                    throw new IllegalArgumentException("newInstance(key) returned null");
                }
            }
            finally {
                newSingletonHolder.set(newInstance);
            }
            return true;
        }
        this.singletonHolderRecycler.add(newSingletonHolder);
        return false;
    }

    public abstract V newInstance(K var1, LogNode var2) throws Exception;

    public V get(K key, LogNode log) throws Exception {
        V existingSingleton = this.getIfPresent(key);
        if (existingSingleton != null) {
            return existingSingleton;
        }
        try {
            this.createSingleton(key, log);
        }
        catch (IOException | IllegalArgumentException e) {
            if (log != null) {
                log.log("Exception while attempting to create singleton " + key + " : " + e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (log != null) {
                log.log("Exception while attempting to create singleton " + key, e);
            }
            throw e;
        }
        V value = this.getIfPresent(key);
        if (value == null) {
            throw new IllegalArgumentException("Previous call to newInstance(key) returned null");
        }
        return value;
    }

    public V getIfPresent(K key) throws InterruptedException {
        SingletonHolder singletonHolder = (SingletonHolder)this.map.get(key);
        return singletonHolder == null ? null : (V)singletonHolder.get();
    }

    public List<V> values() throws InterruptedException {
        ArrayList entries = new ArrayList(this.map.size());
        for (Map.Entry ent : this.map.entrySet()) {
            Object entryValue = ((SingletonHolder)ent.getValue()).get();
            if (entryValue == null) continue;
            entries.add(entryValue);
        }
        return entries;
    }

    public void clear() {
        this.map.clear();
    }

    private static class SingletonHolder<V> {
        private V singleton;
        private final CountDownLatch initialized = new CountDownLatch(1);

        private SingletonHolder() {
        }

        public void set(V singleton) {
            this.singleton = singleton;
            this.initialized.countDown();
        }

        public V get() throws InterruptedException {
            this.initialized.await();
            return this.singleton;
        }
    }
}

