/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.fastzipfilereader;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.fastzipfilereader.FastZipEntry;
import nonapi.io.github.classgraph.fastzipfilereader.ZipFileSlice;
import nonapi.io.github.classgraph.fastzipfilereader.ZipFileSliceReader;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.LogNode;

public class LogicalZipFile
extends ZipFileSlice
implements AutoCloseable {
    private ZipFileSliceReader zipFileSliceReader;
    private List<FastZipEntry> entries;
    int[] multiReleaseVersionsFound;
    public boolean isJREJar;
    public boolean isMultiReleaseJar;
    public List<String> additionalClassPathEntriesToScan;
    Set<String> classpathRoots = Collections.newSetFromMap(new ConcurrentHashMap());
    static final String META_INF_PATH_PREFIX = "META-INF/";
    static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final String MULTI_RELEASE_PATH_PREFIX = "META-INF/versions/";
    private static final byte[] IMPLEMENTATION_TITLE_KEY = LogicalZipFile.manifestKeyToBytes("Implementation-Title");
    private static final byte[] SPECIFICATION_TITLE_KEY = LogicalZipFile.manifestKeyToBytes("Specification-Title");
    private static final byte[] CLASS_PATH_KEY = LogicalZipFile.manifestKeyToBytes("Class-Path");
    private static final byte[] SPRING_BOOT_CLASSES_KEY = LogicalZipFile.manifestKeyToBytes("Spring-Boot-Classes");
    private static final byte[] SPRING_BOOT_LIB_KEY = LogicalZipFile.manifestKeyToBytes("Spring-Boot-Lib");
    private static final byte[] MULTI_RELEASE_KEY = LogicalZipFile.manifestKeyToBytes("Multi-Release");
    private static byte[] toLowerCase = new byte[256];

    private void addAdditionalClassPathEntryToScan(String classPathEntryPath) {
        if (this.additionalClassPathEntriesToScan == null) {
            this.additionalClassPathEntriesToScan = new ArrayList<String>();
        }
        this.additionalClassPathEntriesToScan.add(classPathEntryPath);
    }

    public List<FastZipEntry> getEntries() {
        return this.entries;
    }

    public int[] getMultiReleaseVersionsFound() {
        return this.multiReleaseVersionsFound;
    }

    LogicalZipFile(ZipFileSlice zipFileSlice, ScanSpec scanSpec, LogNode log) throws IOException {
        super(zipFileSlice);
        this.zipFileSliceReader = new ZipFileSliceReader(this);
        this.readCentralDirectory(scanSpec, log);
    }

    private static Map.Entry<String, Integer> getManifestValue(byte[] manifest, int startIdx) {
        String val;
        int len = manifest.length;
        StringBuilder buf = new StringBuilder();
        int curr = startIdx;
        if (curr < len && manifest[curr] == 32) {
            ++curr;
        }
        while (curr < len) {
            byte b = manifest[curr];
            if (b == 13 && curr < len - 1 && manifest[curr + 1] == 10) {
                if ((curr += 2) >= len - 2 || manifest[curr + 2] != 32) {
                    break;
                }
            } else if (b == 13) {
                if (++curr >= len - 1 || manifest[curr + 1] != 32) {
                    break;
                }
            } else if (b == 10) {
                if (++curr >= len - 1 || manifest[curr + 1] != 32) {
                    break;
                }
            } else {
                buf.append((char)b);
            }
            ++curr;
        }
        return new AbstractMap.SimpleEntry<String, Integer>((val = buf.toString()).endsWith(" ") ? val.trim() : val, curr);
    }

    private static byte[] manifestKeyToBytes(String key) {
        byte[] bytes = new byte[key.length()];
        for (int i = 0; i < key.length(); ++i) {
            bytes[i] = (byte)Character.toLowerCase(key.charAt(i));
        }
        return bytes;
    }

    private static boolean keyMatchesAtPosition(byte[] manifest, byte[] key, int pos) {
        if (pos + key.length + 1 > manifest.length || manifest[pos + key.length] != 58) {
            return false;
        }
        for (int i = 0; i < key.length; ++i) {
            if (toLowerCase[manifest[i + pos]] == key[i]) continue;
            return false;
        }
        return true;
    }

    private void parseManifest(FastZipEntry manifestZipEntry, LogNode log) throws IOException {
        byte[] manifest = manifestZipEntry.load(log);
        int i = 0;
        while (i < manifest.length) {
            Map.Entry<String, Integer> manifestValueAndEndIdx;
            boolean skip = false;
            if (manifest[i] == 10 || manifest[i] == 13) {
                skip = true;
            } else if (LogicalZipFile.keyMatchesAtPosition(manifest, IMPLEMENTATION_TITLE_KEY, i)) {
                manifestValueAndEndIdx = LogicalZipFile.getManifestValue(manifest, i + IMPLEMENTATION_TITLE_KEY.length + 1);
                if (manifestValueAndEndIdx.getKey().equalsIgnoreCase("Java Runtime Environment")) {
                    this.isJREJar = true;
                }
                i = manifestValueAndEndIdx.getValue();
            } else if (LogicalZipFile.keyMatchesAtPosition(manifest, SPECIFICATION_TITLE_KEY, i)) {
                manifestValueAndEndIdx = LogicalZipFile.getManifestValue(manifest, i + SPECIFICATION_TITLE_KEY.length + 1);
                if (manifestValueAndEndIdx.getKey().equalsIgnoreCase("Java Platform API Specification")) {
                    this.isJREJar = true;
                }
                i = manifestValueAndEndIdx.getValue();
            } else if (LogicalZipFile.keyMatchesAtPosition(manifest, CLASS_PATH_KEY, i)) {
                manifestValueAndEndIdx = LogicalZipFile.getManifestValue(manifest, i + CLASS_PATH_KEY.length + 1);
                String classPathFieldVal = manifestValueAndEndIdx.getKey();
                if (log != null) {
                    log.log("Found Class-Path entry in manifest file: " + classPathFieldVal);
                }
                for (String classpathEntry : classPathFieldVal.split(" ")) {
                    if (classpathEntry.isEmpty()) continue;
                    this.addAdditionalClassPathEntryToScan(classpathEntry);
                }
                i = manifestValueAndEndIdx.getValue();
            } else if (LogicalZipFile.keyMatchesAtPosition(manifest, SPRING_BOOT_CLASSES_KEY, i)) {
                manifestValueAndEndIdx = LogicalZipFile.getManifestValue(manifest, i + SPRING_BOOT_CLASSES_KEY.length + 1);
                String springBootClassesFieldVal = manifestValueAndEndIdx.getKey();
                if (!(springBootClassesFieldVal.equals("BOOT-INF/classes") || springBootClassesFieldVal.equals("BOOT-INF/classes/") || springBootClassesFieldVal.equals("WEB-INF/classes") || springBootClassesFieldVal.equals("WEB-INF/classes/"))) {
                    throw new IOException("Spring boot classes are at \"" + springBootClassesFieldVal + "\" rather than the standard location \"BOOT-INF/classes/\" or \"WEB-INF/classes/\" -- please report this at https://github.com/classgraph/classgraph/issues");
                }
                i = manifestValueAndEndIdx.getValue();
            } else if (LogicalZipFile.keyMatchesAtPosition(manifest, SPRING_BOOT_LIB_KEY, i)) {
                manifestValueAndEndIdx = LogicalZipFile.getManifestValue(manifest, i + SPRING_BOOT_LIB_KEY.length + 1);
                String springBootLibFieldVal = manifestValueAndEndIdx.getKey();
                if (!(springBootLibFieldVal.equals("BOOT-INF/lib") || springBootLibFieldVal.equals("BOOT-INF/lib/") || springBootLibFieldVal.equals("WEB-INF/lib") || springBootLibFieldVal.equals("WEB-INF/lib/"))) {
                    throw new IOException("Spring boot lib jars are at \"" + springBootLibFieldVal + "\" rather than the standard location \"BOOT-INF/lib/\" or \"WEB-INF/lib/\" -- please report this at https://github.com/classgraph/classgraph/issues");
                }
                i = manifestValueAndEndIdx.getValue();
            } else if (LogicalZipFile.keyMatchesAtPosition(manifest, MULTI_RELEASE_KEY, i)) {
                manifestValueAndEndIdx = LogicalZipFile.getManifestValue(manifest, i + MULTI_RELEASE_KEY.length + 1);
                if (manifestValueAndEndIdx.getKey().equalsIgnoreCase("true")) {
                    this.isMultiReleaseJar = true;
                }
                i = manifestValueAndEndIdx.getValue();
            } else {
                skip = true;
            }
            if (!skip) continue;
            while (i < manifest.length - 2) {
                if (manifest[i] == 13 && manifest[i + 1] == 10 && manifest[i + 2] != 32) {
                    i += 2;
                    break;
                }
                if (manifest[i] == 13 && manifest[i + 1] != 32) {
                    ++i;
                    break;
                }
                if (manifest[i] == 10 && manifest[i + 1] != 32) {
                    ++i;
                    break;
                }
                ++i;
            }
            if (i < manifest.length - 2) continue;
            break;
        }
    }

    private void readCentralDirectory(ScanSpec scanSpec, LogNode log) throws IOException {
        byte[] entryBytes;
        long entriesTotSizeL;
        long eocdPos = -1L;
        for (long i = this.len - 22L; i >= 0L; --i) {
            if (this.zipFileSliceReader.getInt(i) != 101010256) continue;
            eocdPos = i;
            break;
        }
        if (eocdPos < 0L) {
            throw new IOException("Jarfile central directory signature not found: " + this.getPath());
        }
        long numEnt = this.zipFileSliceReader.getShort(eocdPos + 8L);
        if (this.zipFileSliceReader.getShort(eocdPos + 4L) > 0 || this.zipFileSliceReader.getShort(eocdPos + 6L) > 0 || numEnt != (long)this.zipFileSliceReader.getShort(eocdPos + 10L)) {
            throw new IOException("Multi-disk jarfiles not supported: " + this.getPath());
        }
        long cenOff = this.zipFileSliceReader.getInt(eocdPos + 16L);
        long cenSize = this.zipFileSliceReader.getInt(eocdPos + 12L);
        long cenPos = eocdPos - cenSize;
        if (cenSize > eocdPos) {
            throw new IOException("Central directory size out of range: " + cenSize + " vs. " + eocdPos + ": " + this.getPath());
        }
        long zip64cdLocIdx = eocdPos - 20L;
        if (zip64cdLocIdx >= 0L && this.zipFileSliceReader.getInt(zip64cdLocIdx) == 117853008) {
            if (this.zipFileSliceReader.getInt(zip64cdLocIdx + 4L) > 0 || this.zipFileSliceReader.getInt(zip64cdLocIdx + 16L) > 1) {
                throw new IOException("Multi-disk jarfiles not supported: " + this.getPath());
            }
            long eocdPos64 = this.zipFileSliceReader.getLong(zip64cdLocIdx + 8L);
            if (this.zipFileSliceReader.getInt(eocdPos64) != 101075792) {
                throw new IOException("Zip64 central directory at location " + eocdPos64 + " does not have Zip64 central directory header: " + this.getPath());
            }
            long numEnt64 = this.zipFileSliceReader.getLong(eocdPos64 + 24L);
            if (this.zipFileSliceReader.getInt(eocdPos64 + 16L) > 0 || this.zipFileSliceReader.getInt(eocdPos64 + 20L) > 0 || numEnt64 != this.zipFileSliceReader.getLong(eocdPos64 + 32L)) {
                throw new IOException("Multi-disk jarfiles not supported: " + this.getPath());
            }
            numEnt = numEnt != numEnt64 && numEnt != 65535L ? -1L : numEnt64;
            long cenSize64 = this.zipFileSliceReader.getLong(eocdPos64 + 40L);
            if (cenSize != cenSize64 && cenSize != -1L) {
                throw new IOException("Mismatch in central directory size: " + cenSize + " vs. " + cenSize64 + ": " + this.getPath());
            }
            cenSize = cenSize64;
            long cenOff64 = this.zipFileSliceReader.getLong(eocdPos64 + 48L);
            if (cenOff != cenOff64 && cenOff != -1L) {
                throw new IOException("Mismatch in central directory offset: " + cenOff + " vs. " + cenOff64 + ": " + this.getPath());
            }
            cenOff = cenOff64;
            entriesTotSizeL = cenSize - 20L;
        } else {
            entriesTotSizeL = cenSize;
        }
        long locPos = cenPos - cenOff;
        if (locPos < 0L) {
            throw new IOException("Local file header offset out of range: " + locPos + ": " + this.getPath());
        }
        byte[] byArray = entryBytes = entriesTotSizeL > 0x7FFFFFF7L ? null : new byte[(int)entriesTotSizeL];
        if (entryBytes != null) {
            this.zipFileSliceReader.read(cenPos, entryBytes, 0, (int)entriesTotSizeL);
        }
        if (numEnt == -1L) {
            numEnt = 0L;
            long entOff = 0L;
            while (entOff + 46L <= entriesTotSizeL) {
                int sig;
                int n = sig = entryBytes != null ? ZipFileSliceReader.getInt(entryBytes, entOff) : this.zipFileSliceReader.getInt(cenPos + entOff);
                if (sig != 33639248) {
                    throw new IOException("Invalid central directory signature: 0x" + Integer.toString(sig, 16) + ": " + this.getPath());
                }
                int filenameLen = entryBytes != null ? ZipFileSliceReader.getShort(entryBytes, entOff + 28L) : this.zipFileSliceReader.getShort(cenPos + entOff + 28L);
                int extraFieldLen = entryBytes != null ? ZipFileSliceReader.getShort(entryBytes, entOff + 30L) : this.zipFileSliceReader.getShort(cenPos + entOff + 30L);
                int commentLen = entryBytes != null ? ZipFileSliceReader.getShort(entryBytes, entOff + 32L) : this.zipFileSliceReader.getShort(cenPos + entOff + 32L);
                entOff += (long)(46 + filenameLen + extraFieldLen + commentLen);
                ++numEnt;
            }
        }
        if (numEnt > 0x7FFFFFF7L) {
            throw new IOException("Too many zipfile entries: " + numEnt);
        }
        if (entryBytes != null && numEnt > (long)(entryBytes.length / 46)) {
            throw new IOException("Too many zipfile entries: " + numEnt + " (expected a max of " + entryBytes.length / 46 + " based on central directory size)");
        }
        this.entries = new ArrayList<FastZipEntry>((int)numEnt);
        FastZipEntry manifestZipEntry = null;
        long entOff = 0L;
        while (entOff + 46L <= entriesTotSizeL) {
            int sig;
            int n = sig = entryBytes != null ? ZipFileSliceReader.getInt(entryBytes, entOff) : this.zipFileSliceReader.getInt(cenPos + entOff);
            if (sig != 33639248) {
                throw new IOException("Invalid central directory signature: 0x" + Integer.toString(sig, 16) + ": " + this.getPath());
            }
            int filenameLen = entryBytes != null ? ZipFileSliceReader.getShort(entryBytes, entOff + 28L) : this.zipFileSliceReader.getShort(cenPos + entOff + 28L);
            int extraFieldLen = entryBytes != null ? ZipFileSliceReader.getShort(entryBytes, entOff + 30L) : this.zipFileSliceReader.getShort(cenPos + entOff + 30L);
            int commentLen = entryBytes != null ? ZipFileSliceReader.getShort(entryBytes, entOff + 32L) : this.zipFileSliceReader.getShort(cenPos + entOff + 32L);
            long entSize = 46 + filenameLen + extraFieldLen + commentLen;
            long filenameStartOff = entOff + 46L;
            long filenameEndOff = filenameStartOff + (long)filenameLen;
            if (filenameEndOff > entriesTotSizeL) {
                if (log == null) break;
                log.log("Filename extends past end of entry -- skipping entry at offset " + entOff);
                break;
            }
            String entryName = entryBytes != null ? ZipFileSliceReader.getString(entryBytes, filenameStartOff, filenameLen) : this.zipFileSliceReader.getString(cenPos + filenameStartOff, filenameLen);
            String entryNameSanitized = FileUtils.sanitizeEntryPath(entryName, true);
            if (!entryNameSanitized.isEmpty() && !entryName.endsWith("/")) {
                int flags;
                int n2 = flags = entryBytes != null ? ZipFileSliceReader.getShort(entryBytes, entOff + 8L) : this.zipFileSliceReader.getShort(cenPos + entOff + 8L);
                if ((flags & 1) != 0) {
                    if (log != null) {
                        log.log("Skipping encrypted zip entry: " + entryNameSanitized);
                    }
                } else {
                    int compressionMethod;
                    int n3 = compressionMethod = entryBytes != null ? ZipFileSliceReader.getShort(entryBytes, entOff + 10L) : this.zipFileSliceReader.getShort(cenPos + entOff + 10L);
                    if (compressionMethod != 0 && compressionMethod != 8) {
                        if (log != null) {
                            log.log("Skipping zip entry with invalid compression method " + compressionMethod + ": " + entryNameSanitized);
                        }
                    } else {
                        long pos;
                        boolean isDeflated = compressionMethod == 8;
                        long compressedSize = entryBytes != null ? (long)ZipFileSliceReader.getInt(entryBytes, entOff + 20L) : (long)this.zipFileSliceReader.getInt(cenPos + entOff + 20L);
                        long uncompressedSize = entryBytes != null ? (long)ZipFileSliceReader.getInt(entryBytes, entOff + 24L) : (long)this.zipFileSliceReader.getInt(cenPos + entOff + 24L);
                        long l = pos = entryBytes != null ? (long)ZipFileSliceReader.getInt(entryBytes, entOff + 42L) : (long)this.zipFileSliceReader.getInt(cenPos + entOff + 42L);
                        if (extraFieldLen > 0) {
                            int extraFieldOff = 0;
                            while (extraFieldOff + 4 < extraFieldLen) {
                                int size;
                                long tagOff = filenameEndOff + (long)extraFieldOff;
                                int tag = entryBytes != null ? ZipFileSliceReader.getShort(entryBytes, tagOff) : this.zipFileSliceReader.getShort(cenPos + tagOff);
                                int n4 = size = entryBytes != null ? ZipFileSliceReader.getShort(entryBytes, tagOff + 2L) : this.zipFileSliceReader.getShort(cenPos + tagOff + 2L);
                                if (extraFieldOff + 4 + size > extraFieldLen) break;
                                if (tag == 1 && size >= 24) {
                                    long posL;
                                    long compressedSizeL;
                                    long uncompressedSizeL;
                                    long l2 = uncompressedSizeL = entryBytes != null ? ZipFileSliceReader.getLong(entryBytes, tagOff + 4L + 0L) : this.zipFileSliceReader.getLong(cenPos + tagOff + 4L + 0L);
                                    if (uncompressedSize == -1L) {
                                        uncompressedSize = uncompressedSizeL;
                                    }
                                    long l3 = compressedSizeL = entryBytes != null ? ZipFileSliceReader.getLong(entryBytes, tagOff + 4L + 8L) : this.zipFileSliceReader.getLong(cenPos + tagOff + 4L + 8L);
                                    if (compressedSize == -1L) {
                                        compressedSize = compressedSizeL;
                                    }
                                    long l4 = posL = entryBytes != null ? ZipFileSliceReader.getLong(entryBytes, tagOff + 4L + 16L) : this.zipFileSliceReader.getLong(cenPos + tagOff + 4L + 16L);
                                    if (pos != -1L) break;
                                    pos = posL;
                                    break;
                                }
                                extraFieldOff += 4 + size;
                            }
                        }
                        if (compressedSize >= 0L && pos >= 0L) {
                            long locHeaderPos = locPos + pos;
                            if (locHeaderPos < 0L) {
                                if (log != null) {
                                    log.log("Skipping zip entry with invalid loc header position: " + entryNameSanitized);
                                }
                            } else if (locHeaderPos + 4L >= this.len) {
                                if (log != null) {
                                    log.log("Unexpected EOF when trying to read LOC header: " + entryNameSanitized);
                                }
                            } else {
                                FastZipEntry entry = new FastZipEntry(this, locHeaderPos, entryNameSanitized, isDeflated, compressedSize, uncompressedSize, this.physicalZipFile.nestedJarHandler);
                                this.entries.add(entry);
                                if (entry.entryName.equals(MANIFEST_PATH)) {
                                    manifestZipEntry = entry;
                                }
                                if (scanSpec.scanNestedJars && (entry.entryNameUnversioned.startsWith("BOOT-INF/lib/") || entry.entryNameUnversioned.startsWith("BOOT-INF/lib-provided/") || entry.entryNameUnversioned.startsWith("WEB-INF/lib/") || entry.entryNameUnversioned.startsWith("WEB-INF/lib-provided/") || entry.entryNameUnversioned.startsWith("lib/")) && entry.entryNameUnversioned.endsWith(".jar")) {
                                    String entryPath = entry.getPath();
                                    if (log != null) {
                                        log.log("Adding nested lib jar to classpath: " + entryPath);
                                    }
                                    this.addAdditionalClassPathEntryToScan(entryPath);
                                }
                            }
                        }
                    }
                }
            }
            entOff += entSize;
        }
        if (manifestZipEntry != null) {
            this.parseManifest(manifestZipEntry, log);
        }
        if (this.isMultiReleaseJar) {
            if (log != null) {
                log.log("This is a multi-release jar");
            }
            Collections.sort(this.entries);
            ArrayList<FastZipEntry> unversionedZipEntriesMasked = new ArrayList<FastZipEntry>(this.entries.size());
            HashMap<String, String> unversionedPathToVersionedPath = new HashMap<String, String>();
            for (FastZipEntry versionedZipEntry : this.entries) {
                if (!unversionedPathToVersionedPath.containsKey(versionedZipEntry.entryNameUnversioned)) {
                    unversionedPathToVersionedPath.put(versionedZipEntry.entryNameUnversioned, versionedZipEntry.entryName);
                    unversionedZipEntriesMasked.add(versionedZipEntry);
                    continue;
                }
                if (log == null) continue;
                log.log((String)unversionedPathToVersionedPath.get(versionedZipEntry.entryNameUnversioned) + " masks " + versionedZipEntry.entryName);
            }
            this.entries = unversionedZipEntriesMasked;
        }
        HashSet<Integer> versionsFound = new HashSet<Integer>();
        for (FastZipEntry entry : this.entries) {
            int version = !this.isMultiReleaseJar ? 8 : entry.version;
            versionsFound.add(version);
        }
        ArrayList sortedVersionsFound = new ArrayList(versionsFound);
        Collections.sort(sortedVersionsFound, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2 - o1;
            }
        });
        this.multiReleaseVersionsFound = new int[sortedVersionsFound.size()];
        for (int i = 0; i < sortedVersionsFound.size(); ++i) {
            this.multiReleaseVersionsFound[i] = (Integer)sortedVersionsFound.get(i);
        }
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    @Override
    public void close() {
        if (this.zipFileSliceReader != null) {
            this.zipFileSliceReader.close();
            this.zipFileSliceReader = null;
        }
        if (this.entries != null) {
            this.entries.clear();
            this.entries = null;
        }
    }

    static {
        for (int i = 32; i < 127; ++i) {
            LogicalZipFile.toLowerCase[i] = (byte)Character.toLowerCase((char)i);
        }
    }
}

