/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.InterfaceType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.Interface;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.InterfaceKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InterfaceBuilder
implements Builder<Interface> {
    private String _description;
    private Interface.LinkUpDownTrapEnable _linkUpDownTrapEnable;
    private String _name;
    private Class<? extends InterfaceType> _type;
    private Boolean _enabled;
    private InterfaceKey key;
    Map<Class<? extends Augmentation<Interface>>, Augmentation<Interface>> augmentation = Collections.emptyMap();

    public InterfaceBuilder() {
    }

    public InterfaceBuilder(Interface base) {
        Map aug;
        this.key = base.key();
        this._name = base.getName();
        this._description = base.getDescription();
        this._linkUpDownTrapEnable = base.getLinkUpDownTrapEnable();
        this._type = base.getType();
        this._enabled = base.isEnabled();
        if (base instanceof InterfaceImpl) {
            InterfaceImpl impl = (InterfaceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Interface>>, Augmentation<Interface>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Interface>>, Augmentation<Interface>>(aug);
        }
    }

    public InterfaceKey key() {
        return this.key;
    }

    public String getDescription() {
        return this._description;
    }

    public Interface.LinkUpDownTrapEnable getLinkUpDownTrapEnable() {
        return this._linkUpDownTrapEnable;
    }

    public String getName() {
        return this._name;
    }

    public Class<? extends InterfaceType> getType() {
        return this._type;
    }

    public Boolean isEnabled() {
        return this._enabled;
    }

    public <E$$ extends Augmentation<Interface>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public InterfaceBuilder withKey(InterfaceKey key) {
        this.key = key;
        return this;
    }

    public InterfaceBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public InterfaceBuilder setLinkUpDownTrapEnable(Interface.LinkUpDownTrapEnable value) {
        this._linkUpDownTrapEnable = value;
        return this;
    }

    public InterfaceBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public InterfaceBuilder setType(Class<? extends InterfaceType> value) {
        this._type = value;
        return this;
    }

    public InterfaceBuilder setEnabled(Boolean value) {
        this._enabled = value;
        return this;
    }

    public InterfaceBuilder addAugmentation(Class<? extends Augmentation<Interface>> augmentationType, Augmentation<Interface> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Interface>>, Augmentation<Interface>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InterfaceBuilder removeAugmentation(Class<? extends Augmentation<Interface>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Interface build() {
        return new InterfaceImpl(this);
    }

    private static final class InterfaceImpl
    implements Interface {
        private final String _description;
        private final Interface.LinkUpDownTrapEnable _linkUpDownTrapEnable;
        private final String _name;
        private final Class<? extends InterfaceType> _type;
        private final Boolean _enabled;
        private final InterfaceKey key;
        private Map<Class<? extends Augmentation<Interface>>, Augmentation<Interface>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        InterfaceImpl(InterfaceBuilder base) {
            this.key = base.key() != null ? base.key() : new InterfaceKey(base.getName());
            this._name = this.key.getName();
            this._description = base.getDescription();
            this._linkUpDownTrapEnable = base.getLinkUpDownTrapEnable();
            this._type = base.getType();
            this._enabled = base.isEnabled();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Interface> getImplementedInterface() {
            return Interface.class;
        }

        @Override
        public InterfaceKey key() {
            return this.key;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public Interface.LinkUpDownTrapEnable getLinkUpDownTrapEnable() {
            return this._linkUpDownTrapEnable;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Class<? extends InterfaceType> getType() {
            return this._type;
        }

        @Override
        public Boolean isEnabled() {
            return this._enabled;
        }

        public <E$$ extends Augmentation<Interface>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._description);
            result = 31 * result + Objects.hashCode((Object)this._linkUpDownTrapEnable);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._type);
            result = 31 * result + Objects.hashCode(this._enabled);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Interface.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Interface other = (Interface)obj;
            if (!Objects.equals(this._description, other.getDescription())) {
                return false;
            }
            if (!Objects.equals((Object)this._linkUpDownTrapEnable, (Object)other.getLinkUpDownTrapEnable())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (!Objects.equals(this._enabled, other.isEnabled())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InterfaceImpl otherImpl = (InterfaceImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Interface>>, Augmentation<Interface>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Interface");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_description", (Object)this._description);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_linkUpDownTrapEnable", (Object)((Object)this._linkUpDownTrapEnable));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_type", this._type);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_enabled", (Object)this._enabled);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

