/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import io.netty.util.concurrent.EventExecutor;
import java.io.File;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.controller.config.threadpool.ScheduledThreadPool;
import org.opendaylight.controller.config.threadpool.ThreadPool;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.SslHandlerFactory;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.client.conf.NetconfReconnectingClientConfiguration;
import org.opendaylight.netconf.client.conf.NetconfReconnectingClientConfigurationBuilder;
import org.opendaylight.netconf.nettyutil.ReconnectStrategyFactory;
import org.opendaylight.netconf.nettyutil.TimedReconnectStrategyFactory;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.LoginPasswordHandler;
import org.opendaylight.netconf.sal.connect.api.DeviceActionFactory;
import org.opendaylight.netconf.sal.connect.api.NetconfDeviceSchemasResolver;
import org.opendaylight.netconf.sal.connect.api.RemoteDevice;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceHandler;
import org.opendaylight.netconf.sal.connect.netconf.LibraryModulesSchemas;
import org.opendaylight.netconf.sal.connect.netconf.NetconfDevice;
import org.opendaylight.netconf.sal.connect.netconf.NetconfDeviceBuilder;
import org.opendaylight.netconf.sal.connect.netconf.NetconfStateSchemasResolverImpl;
import org.opendaylight.netconf.sal.connect.netconf.SchemalessNetconfDevice;
import org.opendaylight.netconf.sal.connect.netconf.auth.DatastoreBackedPublicKeyAuth;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCapabilities;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCommunicator;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfSessionPreferences;
import org.opendaylight.netconf.sal.connect.netconf.listener.UserPreferences;
import org.opendaylight.netconf.sal.connect.netconf.sal.KeepaliveSalFacade;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfKeystoreAdapter;
import org.opendaylight.netconf.sal.connect.netconf.schema.YangLibrarySchemaYangSourceProvider;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.sal.connect.util.SslHandlerFactoryImpl;
import org.opendaylight.netconf.topology.api.NetconfTopology;
import org.opendaylight.netconf.topology.api.SchemaRepositoryProvider;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.Protocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.available.capabilities.AvailableCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.KeyAuth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPassword;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPw;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPwUnencrypted;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.key.auth.KeyBased;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.login.pw.unencrypted.LoginPasswordUnencrypted;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceFilter;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.util.FilesystemSchemaSourceCache;
import org.opendaylight.yangtools.yang.model.repo.util.InMemorySchemaSourceCache;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ASTSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.TextToASTTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetconfTopology
implements NetconfTopology {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetconfTopology.class);
    protected static final long DEFAULT_REQUEST_TIMEOUT_MILLIS = 60000L;
    protected static final int DEFAULT_KEEPALIVE_DELAY = 0;
    protected static final boolean DEFAULT_RECONNECT_ON_CHANGED_SCHEMA = false;
    protected static final int DEFAULT_CONCURRENT_RPC_LIMIT = 0;
    private static final int DEFAULT_MAX_CONNECTION_ATTEMPTS = 0;
    private static final int DEFAULT_BETWEEN_ATTEMPTS_TIMEOUT_MILLIS = 2000;
    private static final long DEFAULT_CONNECTION_TIMEOUT_MILLIS = 20000L;
    private static final BigDecimal DEFAULT_SLEEP_FACTOR = new BigDecimal(1.5);
    private static final String CACHE_DIRECTORY = "cache";
    private static final String DEFAULT_CACHE_DIRECTORY = "schema";
    private static final String QUALIFIED_DEFAULT_CACHE_DIRECTORY = "cache" + File.separator + "schema";
    private static final String DEFAULT_SCHEMA_REPOSITORY_NAME = "sal-netconf-connector";
    private static final SharedSchemaRepository DEFAULT_SCHEMA_REPOSITORY = new SharedSchemaRepository("sal-netconf-connector");
    public static final InMemorySchemaSourceCache<ASTSchemaSource> DEFAULT_AST_CACHE = InMemorySchemaSourceCache.createSoftCache((SchemaSourceRegistry)DEFAULT_SCHEMA_REPOSITORY, ASTSchemaSource.class);
    private static final SchemaContextFactory DEFAULT_SCHEMA_CONTEXT_FACTORY = DEFAULT_SCHEMA_REPOSITORY.createSchemaContextFactory(SchemaSourceFilter.ALWAYS_ACCEPT);
    private static final Map<String, NetconfDevice.SchemaResourcesDTO> SCHEMA_RESOURCES_DTO_MAP = new HashMap<String, NetconfDevice.SchemaResourcesDTO>();
    private final NetconfClientDispatcher clientDispatcher;
    private final EventExecutor eventExecutor;
    private final DeviceActionFactory deviceActionFactory;
    private final NetconfKeystoreAdapter keystoreAdapter;
    protected final ScheduledThreadPool keepaliveExecutor;
    protected final ListeningExecutorService processingExecutor;
    protected final SharedSchemaRepository sharedSchemaRepository;
    protected final DataBroker dataBroker;
    protected final DOMMountPointService mountPointService;
    protected final String topologyId;
    protected SchemaSourceRegistry schemaRegistry = DEFAULT_SCHEMA_REPOSITORY;
    protected SchemaRepository schemaRepository = DEFAULT_SCHEMA_REPOSITORY;
    protected SchemaContextFactory schemaContextFactory = DEFAULT_SCHEMA_CONTEXT_FACTORY;
    protected String privateKeyPath;
    protected String privateKeyPassphrase;
    protected final AAAEncryptionService encryptionService;
    protected final HashMap<NodeId, NetconfConnectorDTO> activeConnectors = new HashMap();

    protected AbstractNetconfTopology(String topologyId, NetconfClientDispatcher clientDispatcher, EventExecutor eventExecutor, ScheduledThreadPool keepaliveExecutor, ThreadPool processingExecutor, SchemaRepositoryProvider schemaRepositoryProvider, DataBroker dataBroker, DOMMountPointService mountPointService, AAAEncryptionService encryptionService, DeviceActionFactory deviceActionFactory) {
        this.topologyId = topologyId;
        this.clientDispatcher = clientDispatcher;
        this.eventExecutor = eventExecutor;
        this.keepaliveExecutor = keepaliveExecutor;
        this.processingExecutor = MoreExecutors.listeningDecorator((ExecutorService)processingExecutor.getExecutor());
        this.deviceActionFactory = deviceActionFactory;
        this.sharedSchemaRepository = schemaRepositoryProvider.getSharedSchemaRepository();
        this.dataBroker = dataBroker;
        this.mountPointService = mountPointService;
        this.encryptionService = encryptionService;
        this.keystoreAdapter = new NetconfKeystoreAdapter(dataBroker);
    }

    public void setSchemaRegistry(SchemaSourceRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public void setSchemaContextFactory(SchemaContextFactory schemaContextFactory) {
        this.schemaContextFactory = schemaContextFactory;
    }

    @Override
    public ListenableFuture<NetconfDeviceCapabilities> connectNode(NodeId nodeId, Node configNode) {
        LOG.info("Connecting RemoteDevice{{}} , with config {}", (Object)nodeId, (Object)configNode);
        return this.setupConnection(nodeId, configNode);
    }

    @Override
    public ListenableFuture<Void> disconnectNode(NodeId nodeId) {
        LOG.debug("Disconnecting RemoteDevice{{}}", (Object)nodeId.getValue());
        if (!this.activeConnectors.containsKey(nodeId)) {
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("Unable to disconnect device that is not connected"));
        }
        NetconfConnectorDTO connectorDTO = this.activeConnectors.remove(nodeId);
        connectorDTO.getCommunicator().close();
        connectorDTO.getFacade().close();
        return Futures.immediateFuture(null);
    }

    protected ListenableFuture<NetconfDeviceCapabilities> setupConnection(final NodeId nodeId, Node configNode) {
        NetconfNode netconfNode = (NetconfNode)configNode.augmentation(NetconfNode.class);
        Preconditions.checkNotNull((Object)netconfNode.getHost());
        Preconditions.checkNotNull((Object)netconfNode.getPort());
        Preconditions.checkNotNull((Object)netconfNode.isTcpOnly());
        NetconfConnectorDTO deviceCommunicatorDTO = this.createDeviceCommunicator(nodeId, netconfNode);
        NetconfDeviceCommunicator deviceCommunicator = deviceCommunicatorDTO.getCommunicator();
        NetconfClientSessionListener netconfClientSessionListener = deviceCommunicatorDTO.getSessionListener();
        NetconfReconnectingClientConfiguration clientConfig = this.getClientConfig(netconfClientSessionListener, netconfNode);
        ListenableFuture future = deviceCommunicator.initializeRemoteConnection(this.clientDispatcher, (NetconfClientConfiguration)clientConfig);
        this.activeConnectors.put(nodeId, deviceCommunicatorDTO);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<NetconfDeviceCapabilities>(){

            public void onSuccess(NetconfDeviceCapabilities result) {
                LOG.debug("Connector for {} started succesfully", (Object)nodeId.getValue());
            }

            public void onFailure(Throwable throwable) {
                LOG.error("Connector for {} failed", (Object)nodeId.getValue(), (Object)throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    protected NetconfConnectorDTO createDeviceCommunicator(NodeId nodeId, NetconfNode node) {
        NetconfDeviceCommunicator netconfDeviceCommunicator;
        int rpcMessageLimit;
        SchemalessNetconfDevice device;
        long defaultRequestTimeoutMillis = node.getDefaultRequestTimeoutMillis() == null ? 60000L : node.getDefaultRequestTimeoutMillis();
        long keepaliveDelay = node.getKeepaliveDelay() == null ? 0L : node.getKeepaliveDelay();
        boolean reconnectOnChangedSchema = node.isReconnectOnChangedSchema() == null ? false : node.isReconnectOnChangedSchema();
        IpAddress ipAddress = node.getHost().getIpAddress();
        InetSocketAddress address = new InetSocketAddress(ipAddress.getIpv4Address() != null ? ipAddress.getIpv4Address().getValue() : ipAddress.getIpv6Address().getValue(), (int)node.getPort().getValue());
        RemoteDeviceId remoteDeviceId = new RemoteDeviceId(nodeId.getValue(), address);
        KeepaliveSalFacade salFacade = this.createSalFacade(remoteDeviceId);
        if (keepaliveDelay > 0L) {
            LOG.warn("Adding keepalive facade, for device {}", (Object)nodeId);
            salFacade = new KeepaliveSalFacade(remoteDeviceId, salFacade, this.keepaliveExecutor.getExecutor(), keepaliveDelay, defaultRequestTimeoutMillis);
        }
        ArrayList registeredYangLibSources = Lists.newArrayList();
        if (node.getYangLibrary() != null) {
            String yangLibURL = node.getYangLibrary().getYangLibraryUrl().getValue();
            String yangLibUsername = node.getYangLibrary().getUsername();
            String yangLigPassword = node.getYangLibrary().getPassword();
            if (yangLibURL != null) {
                LibraryModulesSchemas libraryModulesSchemas = yangLibUsername != null && yangLigPassword != null ? LibraryModulesSchemas.create((String)yangLibURL, (String)yangLibUsername, (String)yangLigPassword) : LibraryModulesSchemas.create((String)yangLibURL);
                for (Map.Entry sourceIdentifierURLEntry : libraryModulesSchemas.getAvailableModels().entrySet()) {
                    registeredYangLibSources.add(this.schemaRegistry.registerSchemaSource((SchemaSourceProvider)new YangLibrarySchemaYangSourceProvider(remoteDeviceId, libraryModulesSchemas.getAvailableModels()), PotentialSchemaSource.create((SourceIdentifier)((SourceIdentifier)sourceIdentifierURLEntry.getKey()), YangTextSchemaSource.class, (int)PotentialSchemaSource.Costs.REMOTE_IO.getValue())));
                }
            }
        }
        NetconfDevice.SchemaResourcesDTO schemaResourcesDTO = this.setupSchemaCacheDTO(nodeId, node);
        if (node.isSchemaless().booleanValue()) {
            device = new SchemalessNetconfDevice(remoteDeviceId, (RemoteDeviceHandler)salFacade);
        } else {
            NetconfDeviceBuilder netconfDeviceBuilder = new NetconfDeviceBuilder().setReconnectOnSchemasChange(reconnectOnChangedSchema).setSchemaResourcesDTO(schemaResourcesDTO).setGlobalProcessingExecutor(this.processingExecutor).setId(remoteDeviceId).setSalFacade((RemoteDeviceHandler)salFacade);
            if (this.deviceActionFactory != null) {
                netconfDeviceBuilder.setDeviceActionFactory(this.deviceActionFactory);
            }
            device = netconfDeviceBuilder.build();
        }
        Optional<UserPreferences> userCapabilities = AbstractNetconfTopology.getUserCapabilities(node);
        int n = rpcMessageLimit = node.getConcurrentRpcLimit() == null ? 0 : node.getConcurrentRpcLimit();
        if (rpcMessageLimit < 1) {
            LOG.info("Concurrent rpc limit is smaller than 1, no limit will be enforced for device {}", (Object)remoteDeviceId);
        }
        NetconfDeviceCommunicator netconfDeviceCommunicator2 = netconfDeviceCommunicator = userCapabilities.isPresent() ? new NetconfDeviceCommunicator(remoteDeviceId, (RemoteDevice)device, (UserPreferences)userCapabilities.get(), rpcMessageLimit) : new NetconfDeviceCommunicator(remoteDeviceId, (RemoteDevice)device, rpcMessageLimit);
        if (salFacade instanceof KeepaliveSalFacade) {
            salFacade.setListener(netconfDeviceCommunicator);
        }
        return new NetconfConnectorDTO(netconfDeviceCommunicator, (RemoteDeviceHandler<NetconfSessionPreferences>)salFacade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NetconfDevice.SchemaResourcesDTO setupSchemaCacheDTO(NodeId nodeId, NetconfNode node) {
        NetconfDevice.SchemaResourcesDTO schemaResourcesDTO = null;
        String moduleSchemaCacheDirectory = node.getSchemaCacheDirectory();
        if (!Strings.isNullOrEmpty((String)moduleSchemaCacheDirectory)) {
            if (!moduleSchemaCacheDirectory.equals(DEFAULT_CACHE_DIRECTORY)) {
                Map<String, NetconfDevice.SchemaResourcesDTO> map = SCHEMA_RESOURCES_DTO_MAP;
                synchronized (map) {
                    schemaResourcesDTO = SCHEMA_RESOURCES_DTO_MAP.get(moduleSchemaCacheDirectory);
                    if (schemaResourcesDTO == null) {
                        schemaResourcesDTO = this.createSchemaResourcesDTO(moduleSchemaCacheDirectory);
                        schemaResourcesDTO.getSchemaRegistry().registerSchemaSourceListener((SchemaSourceListener)TextToASTTransformer.create((SchemaRepository)((SchemaRepository)schemaResourcesDTO.getSchemaRegistry()), (SchemaSourceRegistry)schemaResourcesDTO.getSchemaRegistry()));
                        SCHEMA_RESOURCES_DTO_MAP.put(moduleSchemaCacheDirectory, schemaResourcesDTO);
                    }
                }
                LOG.info("Netconf connector for device {} will use schema cache directory {} instead of {}", new Object[]{nodeId.getValue(), moduleSchemaCacheDirectory, DEFAULT_CACHE_DIRECTORY});
            }
        } else {
            LOG.warn("schema-cache-directory for {} is null or empty;  using the default {}", (Object)nodeId.getValue(), (Object)QUALIFIED_DEFAULT_CACHE_DIRECTORY);
        }
        if (schemaResourcesDTO == null) {
            schemaResourcesDTO = new NetconfDevice.SchemaResourcesDTO(this.schemaRegistry, this.schemaRepository, this.schemaContextFactory, (NetconfDeviceSchemasResolver)new NetconfStateSchemasResolverImpl());
        }
        return schemaResourcesDTO;
    }

    private NetconfDevice.SchemaResourcesDTO createSchemaResourcesDTO(String moduleSchemaCacheDirectory) {
        SharedSchemaRepository repository = new SharedSchemaRepository(moduleSchemaCacheDirectory);
        SchemaContextFactory contextFactory = repository.createSchemaContextFactory(SchemaSourceFilter.ALWAYS_ACCEPT);
        this.setSchemaRegistry((SchemaSourceRegistry)repository);
        this.setSchemaContextFactory(contextFactory);
        FilesystemSchemaSourceCache<YangTextSchemaSource> deviceCache = this.createDeviceFilesystemCache(moduleSchemaCacheDirectory);
        repository.registerSchemaSourceListener(deviceCache);
        repository.registerSchemaSourceListener((SchemaSourceListener)InMemorySchemaSourceCache.createSoftCache((SchemaSourceRegistry)repository, ASTSchemaSource.class));
        return new NetconfDevice.SchemaResourcesDTO((SchemaSourceRegistry)repository, (SchemaRepository)repository, contextFactory, (NetconfDeviceSchemasResolver)new NetconfStateSchemasResolverImpl());
    }

    private FilesystemSchemaSourceCache<YangTextSchemaSource> createDeviceFilesystemCache(String schemaCacheDirectory) {
        String relativeSchemaCacheDirectory = CACHE_DIRECTORY + File.separator + schemaCacheDirectory;
        return new FilesystemSchemaSourceCache(this.schemaRegistry, YangTextSchemaSource.class, new File(relativeSchemaCacheDirectory));
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    public void setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
    }

    public NetconfReconnectingClientConfiguration getClientConfig(NetconfClientSessionListener listener, NetconfNode node) {
        NetconfReconnectingClientConfigurationBuilder reconnectingClientConfigurationBuilder;
        long clientConnectionTimeoutMillis = node.getConnectionTimeoutMillis() == null ? 20000L : node.getConnectionTimeoutMillis();
        long maxConnectionAttempts = node.getMaxConnectionAttempts() == null ? 0L : node.getMaxConnectionAttempts();
        int betweenAttemptsTimeoutMillis = node.getBetweenAttemptsTimeoutMillis() == null ? 2000 : node.getBetweenAttemptsTimeoutMillis();
        BigDecimal sleepFactor = node.getSleepFactor() == null ? DEFAULT_SLEEP_FACTOR : node.getSleepFactor();
        InetSocketAddress socketAddress = AbstractNetconfTopology.getSocketAddress(node.getHost(), node.getPort().getValue());
        TimedReconnectStrategyFactory sf = new TimedReconnectStrategyFactory(this.eventExecutor, Long.valueOf(maxConnectionAttempts), betweenAttemptsTimeoutMillis, sleepFactor);
        Protocol protocol = node.getProtocol();
        if (node.isTcpOnly().booleanValue()) {
            reconnectingClientConfigurationBuilder = NetconfReconnectingClientConfigurationBuilder.create().withProtocol(NetconfClientConfiguration.NetconfClientProtocol.TCP).withAuthHandler(this.getHandlerFromCredentials(node.getCredentials()));
        } else if (protocol == null || protocol.getName() == Protocol.Name.SSH) {
            reconnectingClientConfigurationBuilder = NetconfReconnectingClientConfigurationBuilder.create().withProtocol(NetconfClientConfiguration.NetconfClientProtocol.SSH).withAuthHandler(this.getHandlerFromCredentials(node.getCredentials()));
        } else if (protocol.getName() == Protocol.Name.TLS) {
            reconnectingClientConfigurationBuilder = NetconfReconnectingClientConfigurationBuilder.create().withSslHandlerFactory((SslHandlerFactory)new SslHandlerFactoryImpl(this.keystoreAdapter, protocol.getSpecification())).withProtocol(NetconfClientConfiguration.NetconfClientProtocol.TLS);
        } else {
            throw new IllegalStateException("Unsupported protocol type: " + protocol.getName());
        }
        if (node.getOdlHelloMessageCapabilities() != null) {
            reconnectingClientConfigurationBuilder.withOdlHelloCapabilities(node.getOdlHelloMessageCapabilities().getCapability());
        }
        return reconnectingClientConfigurationBuilder.withAddress(socketAddress).withConnectionTimeoutMillis(clientConnectionTimeoutMillis).withReconnectStrategy(sf.createReconnectStrategy()).withConnectStrategyFactory((ReconnectStrategyFactory)sf).withSessionListener(listener).build();
    }

    private AuthenticationHandler getHandlerFromCredentials(Credentials credentials) {
        if (credentials instanceof LoginPassword) {
            LoginPassword loginPassword = (LoginPassword)credentials;
            return new LoginPasswordHandler(loginPassword.getUsername(), loginPassword.getPassword());
        }
        if (credentials instanceof LoginPwUnencrypted) {
            LoginPasswordUnencrypted loginPassword = ((LoginPwUnencrypted)credentials).getLoginPasswordUnencrypted();
            return new LoginPasswordHandler(loginPassword.getUsername(), loginPassword.getPassword());
        }
        if (credentials instanceof LoginPw) {
            org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.login.pw.LoginPassword loginPassword = ((LoginPw)credentials).getLoginPassword();
            return new LoginPasswordHandler(loginPassword.getUsername(), this.encryptionService.decrypt(loginPassword.getPassword()));
        }
        if (credentials instanceof KeyAuth) {
            KeyBased keyPair = ((KeyAuth)credentials).getKeyBased();
            return new DatastoreBackedPublicKeyAuth(keyPair.getUsername(), keyPair.getKeyId(), this.keystoreAdapter, this.encryptionService);
        }
        throw new IllegalStateException("Unsupported credential type: " + credentials.getClass());
    }

    protected abstract RemoteDeviceHandler<NetconfSessionPreferences> createSalFacade(RemoteDeviceId var1);

    private static InetSocketAddress getSocketAddress(Host host, int port) {
        if (host.getDomainName() != null) {
            return new InetSocketAddress(host.getDomainName().getValue(), port);
        }
        IpAddress ipAddress = host.getIpAddress();
        String ip = ipAddress.getIpv4Address() != null ? ipAddress.getIpv4Address().getValue() : ipAddress.getIpv6Address().getValue();
        return new InetSocketAddress(ip, port);
    }

    private static Optional<UserPreferences> getUserCapabilities(NetconfNode node) {
        if (node.getYangModuleCapabilities() == null && node.getNonModuleCapabilities() == null) {
            return Optional.absent();
        }
        ArrayList capabilities = new ArrayList();
        boolean overrideYangModuleCaps = false;
        if (node.getYangModuleCapabilities() != null) {
            capabilities.addAll(node.getYangModuleCapabilities().getCapability());
            overrideYangModuleCaps = node.getYangModuleCapabilities().isOverride();
        }
        NetconfSessionPreferences netconfSessionPreferences = NetconfSessionPreferences.fromStrings(capabilities);
        Preconditions.checkState((boolean)netconfSessionPreferences.getNonModuleCaps().isEmpty(), (Object)("List yang-module-capabilities/capability should contain only module based capabilities. Non-module capabilities used: " + netconfSessionPreferences.getNonModuleCaps()));
        boolean overrideNonModuleCaps = false;
        if (node.getNonModuleCapabilities() != null) {
            capabilities.addAll(node.getNonModuleCapabilities().getCapability());
            overrideNonModuleCaps = node.getNonModuleCapabilities().isOverride();
        }
        return Optional.of((Object)new UserPreferences(NetconfSessionPreferences.fromStrings(capabilities, (AvailableCapability.CapabilityOrigin)AvailableCapability.CapabilityOrigin.UserDefined), overrideYangModuleCaps, overrideNonModuleCaps));
    }

    static {
        SCHEMA_RESOURCES_DTO_MAP.put(DEFAULT_CACHE_DIRECTORY, new NetconfDevice.SchemaResourcesDTO((SchemaSourceRegistry)DEFAULT_SCHEMA_REPOSITORY, (SchemaRepository)DEFAULT_SCHEMA_REPOSITORY, DEFAULT_SCHEMA_CONTEXT_FACTORY, (NetconfDeviceSchemasResolver)new NetconfStateSchemasResolverImpl()));
        DEFAULT_SCHEMA_REPOSITORY.registerSchemaSourceListener(DEFAULT_AST_CACHE);
        DEFAULT_SCHEMA_REPOSITORY.registerSchemaSourceListener((SchemaSourceListener)TextToASTTransformer.create((SchemaRepository)DEFAULT_SCHEMA_REPOSITORY, (SchemaSourceRegistry)DEFAULT_SCHEMA_REPOSITORY));
        int tries = 1;
        while (true) {
            try {
                FilesystemSchemaSourceCache defaultCache = new FilesystemSchemaSourceCache((SchemaSourceRegistry)DEFAULT_SCHEMA_REPOSITORY, YangTextSchemaSource.class, new File(QUALIFIED_DEFAULT_CACHE_DIRECTORY));
                DEFAULT_SCHEMA_REPOSITORY.registerSchemaSourceListener((SchemaSourceListener)defaultCache);
            }
            catch (IllegalArgumentException e) {
                if (tries++ >= 3) {
                    LOG.error("Error creating default schema cache", (Throwable)e);
                    break;
                }
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            break;
        }
    }

    protected static class NetconfConnectorDTO
    implements AutoCloseable {
        private final NetconfDeviceCommunicator communicator;
        private final RemoteDeviceHandler<NetconfSessionPreferences> facade;

        public NetconfConnectorDTO(NetconfDeviceCommunicator communicator, RemoteDeviceHandler<NetconfSessionPreferences> facade) {
            this.communicator = communicator;
            this.facade = facade;
        }

        public NetconfDeviceCommunicator getCommunicator() {
            return this.communicator;
        }

        public RemoteDeviceHandler<NetconfSessionPreferences> getFacade() {
            return this.facade;
        }

        public NetconfClientSessionListener getSessionListener() {
            return this.communicator;
        }

        @Override
        public void close() {
            this.communicator.close();
            this.facade.close();
        }
    }
}

