/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.impl;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.util.concurrent.EventExecutor;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.controller.config.threadpool.ScheduledThreadPool;
import org.opendaylight.controller.config.threadpool.ThreadPool;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.sal.connect.api.DeviceActionFactory;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceHandler;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfSessionPreferences;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceSalFacade;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.topology.AbstractNetconfTopology;
import org.opendaylight.netconf.topology.api.SchemaRepositoryProvider;
import org.opendaylight.netconf.topology.impl.TopologyUtil;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfTopologyImpl
extends AbstractNetconfTopology
implements DataTreeChangeListener<Node>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfTopologyImpl.class);
    private ListenerRegistration<NetconfTopologyImpl> datastoreListenerRegistration = null;

    public NetconfTopologyImpl(String topologyId, NetconfClientDispatcher clientDispatcher, EventExecutor eventExecutor, ScheduledThreadPool keepaliveExecutor, ThreadPool processingExecutor, SchemaRepositoryProvider schemaRepositoryProvider, DataBroker dataBroker, DOMMountPointService mountPointService, AAAEncryptionService encryptionService) {
        this(topologyId, clientDispatcher, eventExecutor, keepaliveExecutor, processingExecutor, schemaRepositoryProvider, dataBroker, mountPointService, encryptionService, null);
    }

    public NetconfTopologyImpl(String topologyId, NetconfClientDispatcher clientDispatcher, EventExecutor eventExecutor, ScheduledThreadPool keepaliveExecutor, ThreadPool processingExecutor, SchemaRepositoryProvider schemaRepositoryProvider, DataBroker dataBroker, DOMMountPointService mountPointService, AAAEncryptionService encryptionService, DeviceActionFactory deviceActionFactory) {
        super(topologyId, clientDispatcher, eventExecutor, keepaliveExecutor, processingExecutor, schemaRepositoryProvider, dataBroker, mountPointService, encryptionService, deviceActionFactory);
    }

    @Override
    public void close() {
        for (AbstractNetconfTopology.NetconfConnectorDTO connectorDTO : this.activeConnectors.values()) {
            connectorDTO.close();
        }
        this.activeConnectors.clear();
        if (this.datastoreListenerRegistration != null) {
            this.datastoreListenerRegistration.close();
            this.datastoreListenerRegistration = null;
        }
    }

    @Override
    protected RemoteDeviceHandler<NetconfSessionPreferences> createSalFacade(RemoteDeviceId id) {
        return new NetconfDeviceSalFacade(id, this.mountPointService, this.dataBroker);
    }

    public void init() {
        WriteTransaction wtx = this.dataBroker.newWriteOnlyTransaction();
        this.initTopology(wtx, LogicalDatastoreType.CONFIGURATION);
        this.initTopology(wtx, LogicalDatastoreType.OPERATIONAL);
        wtx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("topology initialization successful");
            }

            public void onFailure(Throwable throwable) {
                LOG.error("Unable to initialize netconf-topology", throwable);
            }
        }, MoreExecutors.directExecutor());
        LOG.debug("Registering datastore listener");
        this.datastoreListenerRegistration = this.dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)TopologyUtil.createTopologyListPath(this.topologyId).child(Node.class)), (DataTreeChangeListener)this);
    }

    public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<Node>> collection) {
        block5: for (DataTreeModification<Node> change : collection) {
            DataObjectModification rootNode = change.getRootNode();
            switch (rootNode.getModificationType()) {
                case SUBTREE_MODIFIED: {
                    LOG.debug("Config for node {} updated", (Object)TopologyUtil.getNodeId(rootNode.getIdentifier()));
                    this.disconnectNode(TopologyUtil.getNodeId(rootNode.getIdentifier()));
                    this.connectNode(TopologyUtil.getNodeId(rootNode.getIdentifier()), (Node)rootNode.getDataAfter());
                    continue block5;
                }
                case WRITE: {
                    LOG.debug("Config for node {} created", (Object)TopologyUtil.getNodeId(rootNode.getIdentifier()));
                    if (this.activeConnectors.containsKey(TopologyUtil.getNodeId(rootNode.getIdentifier()))) {
                        LOG.warn("RemoteDevice{{}} was already configured, reconfiguring..", (Object)TopologyUtil.getNodeId(rootNode.getIdentifier()));
                        this.disconnectNode(TopologyUtil.getNodeId(rootNode.getIdentifier()));
                    }
                    this.connectNode(TopologyUtil.getNodeId(rootNode.getIdentifier()), (Node)rootNode.getDataAfter());
                    continue block5;
                }
                case DELETE: {
                    LOG.debug("Config for node {} deleted", (Object)TopologyUtil.getNodeId(rootNode.getIdentifier()));
                    this.disconnectNode(TopologyUtil.getNodeId(rootNode.getIdentifier()));
                    continue block5;
                }
            }
            LOG.debug("Unsupported modification type: {}.", (Object)rootNode.getModificationType());
        }
    }

    private void initTopology(WriteTransaction wtx, LogicalDatastoreType datastoreType) {
        NetworkTopology networkTopology = new NetworkTopologyBuilder().build();
        InstanceIdentifier networkTopologyId = InstanceIdentifier.builder(NetworkTopology.class).build();
        wtx.merge(datastoreType, networkTopologyId, (DataObject)networkTopology);
        Topology topology = new TopologyBuilder().setTopologyId(new TopologyId(this.topologyId)).build();
        wtx.merge(datastoreType, (InstanceIdentifier)networkTopologyId.child(Topology.class, (Identifier)new TopologyKey(new TopologyId(this.topologyId))), (DataObject)topology);
    }
}

