/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.util;

public final class CloseableUtil {
    private CloseableUtil() {
    }

    public static void closeAll(Iterable<? extends AutoCloseable> autoCloseables) throws Exception {
        Exception lastException = null;
        for (AutoCloseable autoCloseable : autoCloseables) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                if (lastException == null) {
                    lastException = e;
                    continue;
                }
                lastException.addSuppressed(e);
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }
}

