/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.util;

import java.net.InetSocketAddress;
import java.util.Dictionary;
import java.util.Hashtable;
import org.opendaylight.netconf.util.NetconfConfiguration;
import org.opendaylight.netconf.util.NetconfConfigurationHolder;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfConfigurationImpl
implements NetconfConfiguration,
ManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfConfigurationImpl.class);
    private static final String SSH_ADDRESS_PROP = "ssh-address";
    private static final String SSH_PORT_PROP = "ssh-port";
    private static final String TCP_ADDRESS_PROP = "tcp-address";
    private static final String TCP_PORT_PROP = "tcp-port";
    private static final String SSH_PK_PATH_PROP = "ssh-pk-path";
    private NetconfConfigurationHolder netconfConfiguration;

    public NetconfConfigurationImpl(String tcpServerAddress, String tcpServerPort, String sshServerAddress, String sshServerPort, String privateKeyPath) throws NumberFormatException {
        Hashtable<String, String> dictionaryConfig = new Hashtable<String, String>();
        ((Dictionary)dictionaryConfig).put(TCP_ADDRESS_PROP, tcpServerAddress);
        ((Dictionary)dictionaryConfig).put(TCP_PORT_PROP, tcpServerPort);
        ((Dictionary)dictionaryConfig).put(SSH_ADDRESS_PROP, sshServerAddress);
        ((Dictionary)dictionaryConfig).put(SSH_PORT_PROP, sshServerPort);
        ((Dictionary)dictionaryConfig).put(SSH_PK_PATH_PROP, privateKeyPath);
        this.updated(dictionaryConfig);
    }

    public void updated(Dictionary<String, ?> dictionaryConfig) {
        if (dictionaryConfig == null) {
            LOG.debug("CSS NETCONF server configuration cannot be updated as passed dictionary is null");
            return;
        }
        InetSocketAddress sshServerAddress = new InetSocketAddress((String)dictionaryConfig.get(SSH_ADDRESS_PROP), Integer.parseInt((String)dictionaryConfig.get(SSH_PORT_PROP)));
        InetSocketAddress tcpServerAddress = new InetSocketAddress((String)dictionaryConfig.get(TCP_ADDRESS_PROP), Integer.parseInt((String)dictionaryConfig.get(TCP_PORT_PROP)));
        this.netconfConfiguration = new NetconfConfigurationHolder(tcpServerAddress, sshServerAddress, (String)dictionaryConfig.get(SSH_PK_PATH_PROP));
        LOG.debug("CSS netconf server configuration was updated: {}", (Object)dictionaryConfig.toString());
    }

    @Override
    public InetSocketAddress getSshServerAddress() {
        return this.netconfConfiguration.getSshServerAddress();
    }

    @Override
    public InetSocketAddress getTcpServerAddress() {
        return this.netconfConfiguration.getTcpServerAddress();
    }

    @Override
    public String getPrivateKeyPath() {
        return this.netconfConfiguration.getPrivateKeyPath();
    }
}

