/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.util.EffectiveAugmentationSchema;

abstract class StreamingContext<T extends YangInstanceIdentifier.PathArgument>
implements Identifiable<T> {
    private final T identifier;

    StreamingContext(T identifier) {
        this.identifier = identifier;
    }

    static StreamingContext<?> fromSchemaAndQNameChecked(DataNodeContainer schema, QName child) {
        Optional<DataSchemaNode> potential = StreamingContext.findChildSchemaNode(schema, child);
        Preconditions.checkArgument((boolean)potential.isPresent(), (String)"Supplied QName %s is not valid according to schema %s, potential children nodes: %s", (Object)child, (Object)schema, (Object)schema.getChildNodes());
        DataSchemaNode result = potential.get();
        if (schema instanceof DataSchemaNode && result.isAugmenting()) {
            for (AugmentationSchemaNode aug : ((AugmentationTarget)schema).getAvailableAugmentations()) {
                DataSchemaNode found = aug.getDataChildByName(result.getQName());
                if (found == null) continue;
                return new Augmentation(aug, schema);
            }
        }
        return StreamingContext.fromDataSchemaNode(result);
    }

    static StreamingContext<?> fromDataSchemaNode(DataSchemaNode potential) {
        if (potential instanceof ContainerSchemaNode) {
            return new Container((ContainerSchemaNode)potential);
        }
        if (potential instanceof ListSchemaNode) {
            return StreamingContext.fromListSchemaNode((ListSchemaNode)potential);
        }
        if (potential instanceof LeafSchemaNode) {
            return new Leaf((LeafSchemaNode)potential);
        }
        if (potential instanceof ChoiceSchemaNode) {
            return new Choice((ChoiceSchemaNode)potential);
        }
        if (potential instanceof LeafListSchemaNode) {
            return StreamingContext.fromLeafListSchemaNode((LeafListSchemaNode)potential);
        }
        if (potential instanceof AnyXmlSchemaNode) {
            return new AnyXml((AnyXmlSchemaNode)potential);
        }
        return null;
    }

    public final T getIdentifier() {
        return this.identifier;
    }

    abstract StreamingContext<?> getChild(YangInstanceIdentifier.PathArgument var1);

    abstract void streamToWriter(NormalizedNodeStreamWriter var1, YangInstanceIdentifier.PathArgument var2, Iterator<YangInstanceIdentifier.PathArgument> var3) throws IOException;

    abstract boolean isMixin();

    private static Optional<DataSchemaNode> findChildSchemaNode(DataNodeContainer parent, QName child) {
        DataSchemaNode potential = parent.getDataChildByName(child);
        if (potential == null) {
            potential = StreamingContext.findChoice(Iterables.filter((Iterable)parent.getChildNodes(), ChoiceSchemaNode.class), child);
        }
        return Optional.ofNullable(potential);
    }

    private static ChoiceSchemaNode findChoice(Iterable<ChoiceSchemaNode> choices, QName child) {
        for (ChoiceSchemaNode choice : choices) {
            for (CaseSchemaNode caze : choice.getCases().values()) {
                if (!StreamingContext.findChildSchemaNode((DataNodeContainer)caze, child).isPresent()) continue;
                return choice;
            }
        }
        return null;
    }

    private static StreamingContext<?> fromListSchemaNode(ListSchemaNode potential) {
        List keyDefinition = potential.getKeyDefinition();
        if (keyDefinition == null || keyDefinition.isEmpty()) {
            return new UnkeyedListMixin(potential);
        }
        return potential.isUserOrdered() ? new OrderedMapMixin(potential) : new UnorderedMapMixin(potential);
    }

    private static StreamingContext<?> fromLeafListSchemaNode(LeafListSchemaNode potential) {
        return potential.isUserOrdered() ? new OrderedLeafListMixin(potential) : new UnorderedLeafListMixin(potential);
    }

    private static final class UnkeyedListMixin
    extends AbstractComposite<YangInstanceIdentifier.NodeIdentifier> {
        private final UnkeyedListItem innerNode;

        UnkeyedListMixin(ListSchemaNode list) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)list.getQName()));
            this.innerNode = new UnkeyedListItem(list);
        }

        @Override
        StreamingContext<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return child.getNodeType().equals((Object)((YangInstanceIdentifier.NodeIdentifier)((StreamingContext)this).getIdentifier()).getNodeType()) ? this.innerNode : null;
        }

        @Override
        boolean isMixin() {
            return true;
        }

        @Override
        void emitElementStart(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument arg) throws IOException {
            writer.startUnkeyedList((YangInstanceIdentifier.NodeIdentifier)((StreamingContext)this).getIdentifier(), -1);
        }
    }

    private static final class OrderedMapMixin
    extends AbstractMapMixin {
        OrderedMapMixin(ListSchemaNode list) {
            super(list);
        }

        @Override
        void emitElementStart(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument arg) throws IOException {
            writer.startOrderedMapNode((YangInstanceIdentifier.NodeIdentifier)((StreamingContext)this).getIdentifier(), -1);
        }
    }

    private static final class UnorderedMapMixin
    extends AbstractMapMixin {
        UnorderedMapMixin(ListSchemaNode list) {
            super(list);
        }

        @Override
        void emitElementStart(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument arg) throws IOException {
            writer.startMapNode((YangInstanceIdentifier.NodeIdentifier)((StreamingContext)this).getIdentifier(), -1);
        }
    }

    private static final class Augmentation
    extends AbstractDataContainer<YangInstanceIdentifier.AugmentationIdentifier> {
        Augmentation(AugmentationSchemaNode augmentation, DataNodeContainer schema) {
            super(DataSchemaContextNode.augmentationIdentifierFrom((AugmentationSchemaNode)augmentation), (DataNodeContainer)EffectiveAugmentationSchema.create((AugmentationSchemaNode)augmentation, (DataNodeContainer)schema));
        }

        @Override
        boolean isMixin() {
            return true;
        }

        @Override
        void emitElementStart(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument arg) throws IOException {
            writer.startAugmentationNode((YangInstanceIdentifier.AugmentationIdentifier)((StreamingContext)this).getIdentifier());
        }
    }

    private static class UnorderedLeafListMixin
    extends LeafListMixin {
        UnorderedLeafListMixin(LeafListSchemaNode potential) {
            super(potential);
        }

        @Override
        void emitElementStart(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument arg) throws IOException {
            writer.startLeafSet((YangInstanceIdentifier.NodeIdentifier)((StreamingContext)this).getIdentifier(), -1);
        }
    }

    private static final class OrderedLeafListMixin
    extends LeafListMixin {
        OrderedLeafListMixin(LeafListSchemaNode potential) {
            super(potential);
        }

        @Override
        void emitElementStart(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument arg) throws IOException {
            writer.startOrderedLeafSet((YangInstanceIdentifier.NodeIdentifier)((StreamingContext)this).getIdentifier(), -1);
        }
    }

    private static abstract class LeafListMixin
    extends AbstractComposite<YangInstanceIdentifier.NodeIdentifier> {
        private final StreamingContext<?> innerOp;

        LeafListMixin(LeafListSchemaNode potential) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)potential.getQName()));
            this.innerOp = new LeafListEntry(potential);
        }

        @Override
        final StreamingContext<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return child instanceof YangInstanceIdentifier.NodeWithValue ? this.innerOp : null;
        }

        @Override
        final boolean isMixin() {
            return true;
        }
    }

    private static final class Container
    extends AbstractDataContainer<YangInstanceIdentifier.NodeIdentifier> {
        Container(ContainerSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()), (DataNodeContainer)schema);
        }

        @Override
        boolean isMixin() {
            return false;
        }

        @Override
        void emitElementStart(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument arg) throws IOException {
            writer.startContainerNode((YangInstanceIdentifier.NodeIdentifier)((StreamingContext)this).getIdentifier(), -1);
        }
    }

    private static final class UnkeyedListItem
    extends AbstractDataContainer<YangInstanceIdentifier.NodeIdentifier> {
        UnkeyedListItem(ListSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()), (DataNodeContainer)schema);
        }

        @Override
        boolean isMixin() {
            return false;
        }

        @Override
        void emitElementStart(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument arg) throws IOException {
            writer.startUnkeyedListItem((YangInstanceIdentifier.NodeIdentifier)((StreamingContext)this).getIdentifier(), -1);
        }
    }

    private static final class ListEntry
    extends AbstractDataContainer<YangInstanceIdentifier.NodeIdentifierWithPredicates> {
        ListEntry(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, ListSchemaNode schema) {
            super(identifier, (DataNodeContainer)schema);
        }

        @Override
        boolean isMixin() {
            return false;
        }

        @Override
        void emitElementStart(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument arg) throws IOException {
            YangInstanceIdentifier.NodeIdentifierWithPredicates identifier = (YangInstanceIdentifier.NodeIdentifierWithPredicates)arg;
            writer.startMapEntryNode(identifier, -1);
            for (Map.Entry entry : identifier.getKeyValues().entrySet()) {
                writer.leafNode(new YangInstanceIdentifier.NodeIdentifier((QName)entry.getKey()), entry.getValue());
            }
        }
    }

    private static final class LeafListEntry
    extends AbstractSimple<YangInstanceIdentifier.NodeWithValue<?>> {
        LeafListEntry(LeafListSchemaNode potential) {
            super(new YangInstanceIdentifier.NodeWithValue(potential.getQName(), null));
        }

        @Override
        void streamToWriter(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument first, Iterator<YangInstanceIdentifier.PathArgument> others) throws IOException {
            Preconditions.checkArgument((boolean)(first instanceof YangInstanceIdentifier.NodeWithValue));
            YangInstanceIdentifier.NodeWithValue identifier = (YangInstanceIdentifier.NodeWithValue)first;
            writer.leafSetEntryNode(identifier.getNodeType(), identifier.getValue());
        }
    }

    private static final class Leaf
    extends AbstractSimple<YangInstanceIdentifier.NodeIdentifier> {
        Leaf(LeafSchemaNode potential) {
            super(new YangInstanceIdentifier.NodeIdentifier(potential.getQName()));
        }

        @Override
        void streamToWriter(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument first, Iterator<YangInstanceIdentifier.PathArgument> others) throws IOException {
            writer.leafNode((YangInstanceIdentifier.NodeIdentifier)((StreamingContext)this).getIdentifier(), null);
        }
    }

    private static final class Choice
    extends AbstractComposite<YangInstanceIdentifier.NodeIdentifier> {
        private final ImmutableMap<YangInstanceIdentifier.PathArgument, StreamingContext<?>> byArg;

        Choice(ChoiceSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
            ImmutableMap.Builder byArgBuilder = ImmutableMap.builder();
            for (CaseSchemaNode caze : schema.getCases().values()) {
                for (DataSchemaNode cazeChild : caze.getChildNodes()) {
                    StreamingContext<?> childOp = Choice.fromDataSchemaNode(cazeChild);
                    byArgBuilder.put(childOp.getIdentifier(), childOp);
                }
            }
            this.byArg = byArgBuilder.build();
        }

        @Override
        StreamingContext<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return (StreamingContext)this.byArg.get((Object)child);
        }

        @Override
        boolean isMixin() {
            return true;
        }

        @Override
        void emitElementStart(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument arg) throws IOException {
            writer.startChoiceNode((YangInstanceIdentifier.NodeIdentifier)((StreamingContext)this).getIdentifier(), -1);
        }
    }

    private static final class AnyXml
    extends AbstractSimple<YangInstanceIdentifier.NodeIdentifier> {
        AnyXml(AnyXmlSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
        }

        @Override
        void streamToWriter(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument first, Iterator<YangInstanceIdentifier.PathArgument> others) throws IOException {
            writer.anyxmlNode((YangInstanceIdentifier.NodeIdentifier)((StreamingContext)this).getIdentifier(), null);
        }
    }

    private static abstract class AbstractSimple<T extends YangInstanceIdentifier.PathArgument>
    extends StreamingContext<T> {
        AbstractSimple(T identifier) {
            super(identifier);
        }

        @Override
        final StreamingContext<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return null;
        }

        @Override
        final boolean isMixin() {
            return false;
        }
    }

    private static abstract class AbstractMapMixin
    extends AbstractComposite<YangInstanceIdentifier.NodeIdentifier> {
        private final ListEntry innerNode;

        AbstractMapMixin(ListSchemaNode list) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)list.getQName()));
            this.innerNode = new ListEntry(new YangInstanceIdentifier.NodeIdentifierWithPredicates(list.getQName(), (Map)ImmutableMap.of()), list);
        }

        @Override
        final StreamingContext<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return child.getNodeType().equals((Object)((YangInstanceIdentifier.NodeIdentifier)((StreamingContext)this).getIdentifier()).getNodeType()) ? this.innerNode : null;
        }

        @Override
        final boolean isMixin() {
            return true;
        }
    }

    private static abstract class AbstractDataContainer<T extends YangInstanceIdentifier.PathArgument>
    extends AbstractComposite<T> {
        private final Map<YangInstanceIdentifier.PathArgument, StreamingContext<?>> byArg = new HashMap();
        private final DataNodeContainer schema;

        AbstractDataContainer(T identifier, DataNodeContainer schema) {
            super(identifier);
            this.schema = schema;
        }

        @Override
        final StreamingContext<?> getChild(YangInstanceIdentifier.PathArgument child) {
            StreamingContext<?> potential = this.byArg.get(child);
            if (potential != null) {
                return potential;
            }
            potential = this.fromLocalSchema(child);
            if (potential != null) {
                this.byArg.put((YangInstanceIdentifier.PathArgument)potential.getIdentifier(), potential);
            }
            return potential;
        }

        private StreamingContext<?> fromLocalSchema(YangInstanceIdentifier.PathArgument child) {
            if (child instanceof YangInstanceIdentifier.AugmentationIdentifier) {
                return AbstractDataContainer.fromSchemaAndQNameChecked(this.schema, (QName)((YangInstanceIdentifier.AugmentationIdentifier)child).getPossibleChildNames().iterator().next());
            }
            return AbstractDataContainer.fromSchemaAndQNameChecked(this.schema, child.getNodeType());
        }
    }

    private static abstract class AbstractComposite<T extends YangInstanceIdentifier.PathArgument>
    extends StreamingContext<T> {
        AbstractComposite(T identifier) {
            super(identifier);
        }

        @Override
        final void streamToWriter(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.PathArgument first, Iterator<YangInstanceIdentifier.PathArgument> others) throws IOException {
            QName type;
            if (!this.isMixin() && (type = ((StreamingContext)this).getIdentifier().getNodeType()) != null) {
                QName firstType = first.getNodeType();
                Preconditions.checkArgument((boolean)type.equals((Object)firstType), (String)"Node QName must be %s was %s", (Object)type, (Object)firstType);
            }
            this.emitElementStart(writer, first);
            if (others.hasNext()) {
                YangInstanceIdentifier.PathArgument childPath = others.next();
                StreamingContext<?> childOp = this.getChildOperation(childPath);
                childOp.streamToWriter(writer, childPath, others);
            }
            writer.endNode();
        }

        abstract void emitElementStart(NormalizedNodeStreamWriter var1, YangInstanceIdentifier.PathArgument var2) throws IOException;

        private StreamingContext<?> getChildOperation(YangInstanceIdentifier.PathArgument childPath) {
            StreamingContext<?> childOp;
            try {
                childOp = this.getChild(childPath);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(String.format("Failed to process child node %s", childPath), e);
            }
            Preconditions.checkArgument((childOp != null ? 1 : 0) != 0, (String)"Node %s is not allowed inside %s", (Object)childPath, ((StreamingContext)this).getIdentifier());
            return childOp;
        }
    }
}

