/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.util.messages;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class SendErrorExceptionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SendErrorExceptionUtil.class);

    private SendErrorExceptionUtil() {
    }

    public static void sendErrorMessage(NetconfSession session, DocumentedException sendErrorException) {
        LOG.trace("Sending error", (Throwable)sendErrorException);
        Document errorDocument = SendErrorExceptionUtil.createDocument(sendErrorException);
        ChannelFuture channelFuture = session.sendMessage(new NetconfMessage(errorDocument));
        channelFuture.addListener((GenericFutureListener)new SendErrorVerifyingListener(sendErrorException));
    }

    public static void sendErrorMessage(Channel channel, DocumentedException sendErrorException) {
        LOG.trace("Sending error", (Throwable)sendErrorException);
        Document errorDocument = SendErrorExceptionUtil.createDocument(sendErrorException);
        ChannelFuture channelFuture = channel.writeAndFlush((Object)new NetconfMessage(errorDocument));
        channelFuture.addListener((GenericFutureListener)new SendErrorVerifyingListener(sendErrorException));
    }

    public static void sendErrorMessage(NetconfSession session, DocumentedException sendErrorException, NetconfMessage incommingMessage) {
        Document errorDocument = SendErrorExceptionUtil.createDocument(sendErrorException);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending error {}", (Object)XmlUtil.toString((Document)errorDocument));
        }
        SendErrorExceptionUtil.tryToCopyAttributes(incommingMessage.getDocument(), errorDocument, sendErrorException);
        ChannelFuture channelFuture = session.sendMessage(new NetconfMessage(errorDocument));
        channelFuture.addListener((GenericFutureListener)new SendErrorVerifyingListener(sendErrorException));
    }

    private static void tryToCopyAttributes(Document incommingDocument, Document errorDocument, DocumentedException sendErrorException) {
        try {
            Element incommingRpc = incommingDocument.getDocumentElement();
            Preconditions.checkState(("rpc".equals(incommingRpc.getLocalName()) && "urn:ietf:params:xml:ns:netconf:base:1.0".equals(incommingRpc.getNamespaceURI()) ? 1 : 0) != 0, (String)"Missing %s element", (Object)"rpc");
            Element rpcReply = errorDocument.getDocumentElement();
            Preconditions.checkState((boolean)rpcReply.getTagName().equals("rpc-reply"), (String)"Missing %s element", (Object)"rpc-reply");
            NamedNodeMap incomingAttributes = incommingRpc.getAttributes();
            for (int i = 0; i < incomingAttributes.getLength(); ++i) {
                Attr attr = (Attr)incomingAttributes.item(i);
                if (attr.getNodeName().equals("xmlns")) continue;
                rpcReply.setAttributeNode((Attr)errorDocument.importNode(attr, true));
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to copy incomming attributes to {}, returned rpc-error might be invalid for client", (Object)sendErrorException, (Object)e);
        }
    }

    private static Document createDocument(DocumentedException sendErrorException) {
        return sendErrorException.toXMLDocument();
    }

    private static final class SendErrorVerifyingListener
    implements ChannelFutureListener {
        private final DocumentedException sendErrorException;

        SendErrorVerifyingListener(DocumentedException sendErrorException) {
            this.sendErrorException = sendErrorException;
        }

        public void operationComplete(ChannelFuture channelFuture) {
            Preconditions.checkState((boolean)channelFuture.isSuccess(), (String)"Unable to send exception %s", (Object)((Object)this.sendErrorException), (Object)channelFuture.cause());
        }
    }
}

