/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.util.xml;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class HardcodedNamespaceResolver
implements NamespaceContext {
    private final Map<String, String> prefixesToNamespaces;

    public HardcodedNamespaceResolver(String prefix, String namespace) {
        this((Map<String, String>)ImmutableMap.of((Object)prefix, (Object)namespace));
    }

    public HardcodedNamespaceResolver(Map<String, String> prefixesToNamespaces) {
        this.prefixesToNamespaces = Collections.unmodifiableMap(prefixesToNamespaces);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.prefixesToNamespaces.containsKey(prefix)) {
            return this.prefixesToNamespaces.get(prefix);
        }
        throw new IllegalStateException("Prefix mapping not found for " + prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return null;
    }
}

