/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.transform;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.transform.QNameModuleReplacementFunction;
import org.opendaylight.yangtools.transform.QNameReplacementFunction;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ForwardingNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;

public abstract class QNameTransformingStreamWriter
extends ForwardingNormalizedNodeStreamWriter {
    public static NormalizedNodeStreamWriter fromFunction(final NormalizedNodeStreamWriter delegate, final Function<QName, QName> transformation) {
        return new QNameTransformingStreamWriter(){

            protected NormalizedNodeStreamWriter delegate() {
                return delegate;
            }

            @Override
            protected QName transform(QName key) {
                return (QName)transformation.apply(key);
            }
        };
    }

    public static NormalizedNodeStreamWriter createQNameReplacing(NormalizedNodeStreamWriter delegate, Map<QName, QName> mapping) {
        return QNameTransformingStreamWriter.fromFunction(delegate, new QNameReplacementFunction(mapping));
    }

    public static NormalizedNodeStreamWriter createQNameModuleReplacing(NormalizedNodeStreamWriter delegate, Map<QNameModule, QNameModule> mapping) {
        return QNameTransformingStreamWriter.fromFunction(delegate, new QNameModuleReplacementFunction(mapping));
    }

    public void leafNode(YangInstanceIdentifier.NodeIdentifier name, Object value) throws IOException {
        super.leafNode(this.transform(name), value);
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startLeafSet(this.transform(name), childSizeHint);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startOrderedLeafSet(this.transform(name), childSizeHint);
    }

    public void leafSetEntryNode(QName name, Object value) throws IOException {
        super.leafSetEntryNode(this.transform(name), value);
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startContainerNode(this.transform(name), childSizeHint);
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startUnkeyedList(this.transform(name), childSizeHint);
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startUnkeyedListItem(this.transform(name), childSizeHint);
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startMapNode(this.transform(name), childSizeHint);
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        super.startMapEntryNode(this.transform(identifier), childSizeHint);
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startOrderedMapNode(this.transform(name), childSizeHint);
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startChoiceNode(this.transform(name), childSizeHint);
    }

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) throws IOException {
        super.startAugmentationNode(this.transform(identifier));
    }

    public void anyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Object value) throws IOException {
        super.anyxmlNode(this.transform(name), value);
    }

    public void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startYangModeledAnyXmlNode(this.transform(name), childSizeHint);
    }

    protected abstract @NonNull QName transform(@NonNull QName var1);

    private YangInstanceIdentifier.NodeIdentifier transform(YangInstanceIdentifier.NodeIdentifier name) {
        QName original = name.getNodeType();
        QName transformed = this.transform(original);
        return transformed == original ? name : new YangInstanceIdentifier.NodeIdentifier(transformed);
    }

    private YangInstanceIdentifier.AugmentationIdentifier transform(YangInstanceIdentifier.AugmentationIdentifier identifier) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (QName original : identifier.getPossibleChildNames()) {
            builder.add((Object)this.transform(original));
        }
        return new YangInstanceIdentifier.AugmentationIdentifier((Set)builder.build());
    }

    private YangInstanceIdentifier.NodeIdentifierWithPredicates transform(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier) {
        HashMap keyValues = new HashMap();
        for (Map.Entry original : identifier.getKeyValues().entrySet()) {
            keyValues.put(this.transform((QName)original.getKey()), original.getValue());
        }
        return new YangInstanceIdentifier.NodeIdentifierWithPredicates(this.transform(identifier.getNodeType()), keyValues);
    }
}

