/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdOrZeroType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionStart;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NetconfSessionStartBuilder
implements Builder<NetconfSessionStart> {
    private SessionIdOrZeroType _sessionId;
    private IpAddress _sourceHost;
    private String _username;
    Map<Class<? extends Augmentation<NetconfSessionStart>>, Augmentation<NetconfSessionStart>> augmentation = Collections.emptyMap();

    public NetconfSessionStartBuilder() {
    }

    public NetconfSessionStartBuilder(CommonSessionParms arg) {
        this._username = arg.getUsername();
        this._sessionId = arg.getSessionId();
        this._sourceHost = arg.getSourceHost();
    }

    public NetconfSessionStartBuilder(NetconfSessionStart base) {
        Map aug;
        this._sessionId = base.getSessionId();
        this._sourceHost = base.getSourceHost();
        this._username = base.getUsername();
        if (base instanceof NetconfSessionStartImpl) {
            NetconfSessionStartImpl impl = (NetconfSessionStartImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NetconfSessionStart>>, Augmentation<NetconfSessionStart>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfSessionStart>>, Augmentation<NetconfSessionStart>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonSessionParms) {
            this._username = ((CommonSessionParms)arg).getUsername();
            this._sessionId = ((CommonSessionParms)arg).getSessionId();
            this._sourceHost = ((CommonSessionParms)arg).getSourceHost();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.CommonSessionParms]");
    }

    public SessionIdOrZeroType getSessionId() {
        return this._sessionId;
    }

    public IpAddress getSourceHost() {
        return this._sourceHost;
    }

    public String getUsername() {
        return this._username;
    }

    public <E$$ extends Augmentation<NetconfSessionStart>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NetconfSessionStartBuilder setSessionId(SessionIdOrZeroType value) {
        this._sessionId = value;
        return this;
    }

    public NetconfSessionStartBuilder setSourceHost(IpAddress value) {
        this._sourceHost = value;
        return this;
    }

    public NetconfSessionStartBuilder setUsername(String value) {
        this._username = value;
        return this;
    }

    public NetconfSessionStartBuilder addAugmentation(Class<? extends Augmentation<NetconfSessionStart>> augmentationType, Augmentation<NetconfSessionStart> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfSessionStart>>, Augmentation<NetconfSessionStart>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NetconfSessionStartBuilder removeAugmentation(Class<? extends Augmentation<NetconfSessionStart>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NetconfSessionStart build() {
        return new NetconfSessionStartImpl(this);
    }

    private static final class NetconfSessionStartImpl
    implements NetconfSessionStart {
        private final SessionIdOrZeroType _sessionId;
        private final IpAddress _sourceHost;
        private final String _username;
        private Map<Class<? extends Augmentation<NetconfSessionStart>>, Augmentation<NetconfSessionStart>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetconfSessionStartImpl(NetconfSessionStartBuilder base) {
            this._sessionId = base.getSessionId();
            this._sourceHost = base.getSourceHost();
            this._username = base.getUsername();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NetconfSessionStart> getImplementedInterface() {
            return NetconfSessionStart.class;
        }

        @Override
        public SessionIdOrZeroType getSessionId() {
            return this._sessionId;
        }

        @Override
        public IpAddress getSourceHost() {
            return this._sourceHost;
        }

        @Override
        public String getUsername() {
            return this._username;
        }

        public <E$$ extends Augmentation<NetconfSessionStart>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._sessionId);
            result = 31 * result + Objects.hashCode(this._sourceHost);
            result = 31 * result + Objects.hashCode(this._username);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NetconfSessionStart.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NetconfSessionStart other = (NetconfSessionStart)obj;
            if (!Objects.equals(this._sessionId, other.getSessionId())) {
                return false;
            }
            if (!Objects.equals(this._sourceHost, other.getSourceHost())) {
                return false;
            }
            if (!Objects.equals(this._username, other.getUsername())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NetconfSessionStartImpl otherImpl = (NetconfSessionStartImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NetconfSessionStart>>, Augmentation<NetconfSessionStart>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NetconfSessionStart");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sessionId", (Object)this._sessionId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sourceHost", (Object)this._sourceHost);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_username", (Object)this._username);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

