/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseRequestMessage;
import org.opendaylight.jsonrpc.bus.messagelib.MethodCandidate;
import org.opendaylight.jsonrpc.bus.messagelib.NameMatchingPredicate;
import org.opendaylight.jsonrpc.bus.messagelib.StrictMatchingPredicate;
import org.opendaylight.jsonrpc.bus.messagelib.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractProxyHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProxyHandlerAdapter.class);
    protected final Object handler;
    private final List<Method> methods;

    AbstractProxyHandlerAdapter(boolean skipOutputMethods, Object handler) {
        this.handler = Objects.requireNonNull(handler);
        this.methods = this.filterOutputMethods(handler.getClass().getMethods(), skipOutputMethods);
    }

    private List<Method> filterOutputMethods(Method[] decaredMethods, boolean skipOutputMethods) {
        return Arrays.stream(decaredMethods).filter(method -> {
            if (skipOutputMethods) {
                return method.getReturnType().equals(Void.TYPE);
            }
            return true;
        }).collect(Collectors.toList());
    }

    protected List<Method> findMethodStrict(JsonRpcBaseRequestMessage msg) {
        return this.methods.stream().filter(new StrictMatchingPredicate(msg)).sorted(Util.nameAndArgsSorter()).collect(Collectors.toList());
    }

    protected List<Method> findMethodLenient(JsonRpcBaseRequestMessage msg) {
        return this.methods.stream().filter(new NameMatchingPredicate(msg)).sorted(Util.nameAndArgsSorter()).collect(Collectors.toList());
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"})
    protected Object invokeHandler(JsonRpcBaseRequestMessage message) throws Exception {
        ArrayList<MethodCandidate> candidates = new ArrayList<MethodCandidate>();
        List<Method> opt = this.findMethodStrict(message);
        if (!opt.isEmpty()) {
            for (Method m : opt) {
                MethodCandidate mc = new MethodCandidate(this.handler, m);
                LOG.debug("Attempting method candidate {}", (Object)mc);
                candidates.add(mc);
                mc.invoke(message);
                if (!mc.isSuccess()) continue;
                return mc.result();
            }
            throw this.findClosestFailure(candidates);
        }
        opt = this.findMethodLenient(message);
        if (!opt.isEmpty()) {
            String msg = String.format("Found method but wrong number of arguments: %s", message.getMethod());
            LOG.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        throw new NoSuchMethodException(String.format("Method not found : %s", message.getMethod()));
    }

    private Exception findClosestFailure(List<MethodCandidate> candidates) {
        return Stream.concat(candidates.stream().filter(c -> c.getPostInvokeFailure() != null), candidates.stream().filter(c -> c.getPreInvokeFailure() != null)).findFirst().get().getFailure();
    }

    protected String getErrorMessage(Exception error) {
        Throwable inner = error.getCause();
        String errorMessage = inner != null ? inner.getMessage() : error.getMessage();
        if (errorMessage == null) {
            errorMessage = "Internal error";
        }
        return errorMessage;
    }
}

