/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.opendaylight.jsonrpc.bus.messagelib.BaseSession;
import org.opendaylight.jsonrpc.bus.messagelib.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSession
implements BaseSession {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSession.class);
    private final AtomicInteger id = new AtomicInteger();
    private AutoCloseable closeable;
    private final Consumer<AutoCloseable> closeCallback;
    private final AtomicInteger refCount = new AtomicInteger(0);
    protected final long timeout;

    AbstractSession(Consumer<AutoCloseable> closeCallback, String uri) {
        this.closeCallback = Objects.requireNonNull(closeCallback);
        this.timeout = Util.queryParamValue(uri, "timeout", 30000L);
    }

    protected void setAutocloseable(AutoCloseable autoCloseable) {
        this.closeable = autoCloseable;
    }

    protected int nextId() {
        return this.id.incrementAndGet();
    }

    @Override
    public void close() {
        if (this.refCount.decrementAndGet() == 0) {
            LOG.debug("Reference count reached 0, closing and removing {}", (Object)this.closeable);
            Util.closeQuietly(this.closeable);
            this.closeCallback.accept(this);
        }
    }

    public void addReference() {
        this.refCount.incrementAndGet();
    }

    public String toString() {
        return "AbstractSession [closeable=" + this.closeable + ", timeout=" + this.timeout + "]";
    }
}

