/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.opendaylight.jsonrpc.bus.api.BusSessionFactoryProvider;
import org.opendaylight.jsonrpc.bus.messagelib.BaseSession;
import org.opendaylight.jsonrpc.bus.messagelib.ClientSession;
import org.opendaylight.jsonrpc.bus.messagelib.EndpointBuilders;
import org.opendaylight.jsonrpc.bus.messagelib.MessageLibrary;
import org.opendaylight.jsonrpc.bus.messagelib.ProxyService;
import org.opendaylight.jsonrpc.bus.messagelib.ProxyServiceImpl;
import org.opendaylight.jsonrpc.bus.messagelib.ReplyMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.RequesterSession;
import org.opendaylight.jsonrpc.bus.messagelib.ResponderHandlerAdapter;
import org.opendaylight.jsonrpc.bus.messagelib.ResponderSession;
import org.opendaylight.jsonrpc.bus.messagelib.SubscriberHandlerAdapter;
import org.opendaylight.jsonrpc.bus.messagelib.SubscriberSession;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;

public abstract class AbstractTransportFactory
implements TransportFactory {
    private final LoadingCache<String, MessageLibrary> messageLibraryCache;
    private final LoadingCache<MessageLibrary, ProxyService> proxyCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<MessageLibrary, ProxyService>(){

        public ProxyService load(MessageLibrary key) throws Exception {
            return new ProxyServiceImpl(key);
        }
    });

    protected AbstractTransportFactory(final BusSessionFactoryProvider busSessionFactoryProvider) {
        this.messageLibraryCache = CacheBuilder.newBuilder().weakValues().removalListener(e -> ((MessageLibrary)e.getValue()).close()).build((CacheLoader)new CacheLoader<String, MessageLibrary>(){

            public MessageLibrary load(String key) throws Exception {
                return new MessageLibrary(busSessionFactoryProvider, key);
            }
        });
    }

    @Override
    public <T extends AutoCloseable> T createPublisherProxy(Class<T> clazz, String rawUri, boolean skipCache) throws URISyntaxException {
        URI uri = new URI(rawUri);
        AbstractTransportFactory.ensureTransport(uri);
        MessageLibrary messageLibrary = this.getMessageLibraryForTransport(uri.getScheme());
        ProxyService proxy = (ProxyService)this.proxyCache.getUnchecked((Object)messageLibrary);
        return proxy.createPublisherProxy(uri.toString(), clazz, skipCache);
    }

    @Override
    public <T extends AutoCloseable> T createPublisherProxy(Class<T> clazz, String rawUri) throws URISyntaxException {
        return this.createPublisherProxy(clazz, rawUri, true);
    }

    @Override
    public <T extends AutoCloseable> T createRequesterProxy(Class<T> clazz, String rawUri) throws URISyntaxException {
        return this.createRequesterProxy(clazz, rawUri, true);
    }

    @Override
    public <T extends AutoCloseable> T createRequesterProxy(Class<T> clazz, String rawUri, boolean skipCache) throws URISyntaxException {
        URI uri = new URI(rawUri);
        AbstractTransportFactory.ensureTransport(uri);
        MessageLibrary messageLibrary = this.getMessageLibraryForTransport(uri.getScheme());
        ProxyService proxy = (ProxyService)this.proxyCache.getUnchecked((Object)messageLibrary);
        return proxy.createRequesterProxy(uri.toString(), clazz, skipCache);
    }

    @Override
    public <T extends AutoCloseable> ResponderSession createResponder(String rawUri, T handler) throws URISyntaxException {
        return this.createResponder(rawUri, handler, true);
    }

    @Override
    public <T extends AutoCloseable> ResponderSession createResponder(String rawUri, T handler, boolean skipCache) throws URISyntaxException {
        URI uri = new URI(rawUri);
        AbstractTransportFactory.ensureTransport(uri);
        return this.getMessageLibraryForTransport(uri.getScheme()).responder(rawUri, new ResponderHandlerAdapter(handler), skipCache);
    }

    @Override
    public <T extends AutoCloseable> SubscriberSession createSubscriber(String rawUri, T handler) throws URISyntaxException {
        return this.createSubscriber(rawUri, handler, true);
    }

    @Override
    public <T extends AutoCloseable> SubscriberSession createSubscriber(String rawUri, T handler, boolean skipCache) throws URISyntaxException {
        URI uri = new URI(rawUri);
        AbstractTransportFactory.ensureTransport(uri);
        return this.getMessageLibraryForTransport(uri.getScheme()).subscriber(rawUri, new SubscriberHandlerAdapter(handler), skipCache);
    }

    @Override
    public RequesterSession createRequester(String rawUri, ReplyMessageHandler handler) throws URISyntaxException {
        return this.createRequester(rawUri, handler, true);
    }

    @Override
    public RequesterSession createRequester(String rawUri, ReplyMessageHandler handler, boolean skipCache) throws URISyntaxException {
        URI uri = new URI(rawUri);
        AbstractTransportFactory.ensureTransport(uri);
        return this.getMessageLibraryForTransport(uri.getScheme()).requester(rawUri, handler, skipCache);
    }

    @Override
    public void close() {
        this.messageLibraryCache.cleanUp();
        this.proxyCache.cleanUp();
    }

    @Override
    public MessageLibrary getMessageLibraryForTransport(String transport) {
        return (MessageLibrary)this.messageLibraryCache.getUnchecked((Object)transport);
    }

    @Override
    public EndpointBuilders.EndpointBuilder endpointBuilder() {
        return new EndpointBuilders.EndpointBuilder(this);
    }

    @Override
    public boolean isClientConnected(Object proxyOrSession) {
        if (Proxy.isProxyClass(proxyOrSession.getClass())) {
            Optional<BaseSession> session = this.proxyCache.asMap().values().stream().map(x -> x.getProxySession(proxyOrSession)).filter(Optional::isPresent).map(Optional::get).findFirst();
            return session.isPresent() && session.get() instanceof ClientSession && ((ClientSession)session.get()).isConnectionReady();
        }
        return proxyOrSession instanceof ClientSession && ((ClientSession)proxyOrSession).isConnectionReady();
    }

    private static void ensureTransport(URI uri) {
        Preconditions.checkArgument((uri.getScheme() != null ? 1 : 0) != 0, (String)"Transport is required, but not provided in URI : %s", (Object)uri);
    }
}

