/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseRequestMessage;

public class NameMatchingPredicate
implements Predicate<Method> {
    protected final JsonRpcBaseRequestMessage msg;

    public NameMatchingPredicate(JsonRpcBaseRequestMessage msg) {
        this.msg = msg;
    }

    @Override
    public boolean test(Method method) {
        boolean nameMatched = false;
        nameMatched |= method.getName().equalsIgnoreCase(this.toUnderscoreName(this.msg.getMethod()));
        return nameMatched |= method.getName().equalsIgnoreCase(this.toCamelCaseName(this.msg.getMethod()));
    }

    private String toUnderscoreName(String name) {
        return name.replaceAll("-", "_").replaceAll("\\.", "_");
    }

    private String toCamelCaseName(String name) {
        String ret = Arrays.asList(name.split("_|-|\\.")).stream().map(n -> {
            if (n.length() > 0) {
                return n.substring(0, 1).toUpperCase() + n.substring(1);
            }
            return n.toUpperCase();
        }).collect(Collectors.joining());
        return Character.toLowerCase(ret.charAt(0)) + ret.substring(1);
    }
}

