/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import java.util.List;
import java.util.Objects;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.PeerContext;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcNotificationMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcSerializer;
import org.opendaylight.jsonrpc.bus.messagelib.MessageLibraryMismatchException;
import org.opendaylight.jsonrpc.bus.messagelib.NotificationMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHandlerAdapter
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationHandlerAdapter.class);
    private final NotificationMessageHandler handler;

    public NotificationHandlerAdapter(NotificationMessageHandler handler) {
        this.handler = Objects.requireNonNull(handler);
    }

    public void onMessage(PeerContext peerContext, String message) {
        LOG.debug("Notification : {}", (Object)message);
        List incoming = JsonRpcSerializer.fromJson((String)message);
        for (JsonRpcBaseMessage notification : incoming) {
            if (notification.getType() != JsonRpcBaseMessage.JsonRpcMessageType.NOTIFICATION) {
                throw new MessageLibraryMismatchException(String.format("Expected NOTIFICATION, but got %s message", notification.getType().name()));
            }
            this.handler.handleNotification((JsonRpcNotificationMessage)notification);
        }
    }
}

