/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseRequestMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcErrorObject;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcException;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcReplyMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcRequestMessage;
import org.opendaylight.jsonrpc.bus.messagelib.AbstractProxyHandlerAdapter;
import org.opendaylight.jsonrpc.bus.messagelib.RequestMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponderHandlerAdapter
extends AbstractProxyHandlerAdapter
implements RequestMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ResponderHandlerAdapter.class);

    public ResponderHandlerAdapter(Object handler) {
        super(false, handler);
    }

    @Override
    public void handleRequest(JsonRpcRequestMessage request, JsonRpcReplyMessage.Builder replyBuilder) {
        if (this.handler instanceof RequestMessageHandler) {
            ((RequestMessageHandler)this.handler).handleRequest(request, replyBuilder);
            return;
        }
        try {
            Object response = this.invokeHandler((JsonRpcBaseRequestMessage)request);
            replyBuilder.resultFromObject(response);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Request method not found: {}", (Object)request.getMethod());
            JsonRpcErrorObject error = new JsonRpcErrorObject(Integer.valueOf(-32601), "Method not found", null);
            replyBuilder.error(error);
        }
        catch (IllegalArgumentException | JsonRpcException e) {
            LOG.error("Invalid arguments", e);
            JsonRpcErrorObject error = new JsonRpcErrorObject(Integer.valueOf(-32602), "Invalid params", null);
            replyBuilder.error(error);
        }
        catch (Exception e) {
            LOG.error("Error while executing method: {}", (Object)request.getMethod(), (Object)e);
            JsonRpcErrorObject error = new JsonRpcErrorObject(Integer.valueOf(-32000), this.getErrorMessage(e), null);
            replyBuilder.error(error);
        }
    }
}

