/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.messagelib;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseRequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static final Joiner.MapJoiner QUERY_JOINER = Joiner.on((char)'&').withKeyValueSeparator("=");

    private Util() {
    }

    public static String removeParams(String rawQuery, String ... paramsToRemove) {
        if (paramsToRemove == null || paramsToRemove.length == 0) {
            return rawQuery;
        }
        Map<String, String> params = Util.tokenizeQuery(rawQuery);
        Map map = params.entrySet().stream().filter(e -> !Arrays.asList(paramsToRemove).contains(((String)e.getKey()).trim())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, second) -> first, LinkedHashMap::new));
        return QUERY_JOINER.join(map);
    }

    static Map<String, String> tokenizeQuery(String rawUri) {
        return UriTokenizer.tokenize(rawUri);
    }

    public static int getParametersCount(JsonRpcBaseRequestMessage msg) {
        if (msg.getParams() instanceof JsonArray) {
            return ((JsonArray)msg.getParams()).size();
        }
        if (msg.getParams() instanceof JsonPrimitive) {
            return 1;
        }
        if (msg.getParams() instanceof JsonObject) {
            return 1;
        }
        return 0;
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    public static void closeQuietly(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Comparator<Method> nameSorter() {
        return (o1, o2) -> {
            if (o1.getName().contains("_")) {
                return 1;
            }
            if (o2.getName().contains("_")) {
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        };
    }

    public static Comparator<Method> argsSorter() {
        return (left, right) -> Arrays.asList(left.getParameterTypes()).stream().map(Object::toString).collect(Collectors.toList()).hashCode() - Arrays.asList(right.getParameterTypes()).stream().map(Object::toString).collect(Collectors.toList()).hashCode();
    }

    public static Comparator<Method> nameAndArgsSorter() {
        return (left, right) -> ComparisonChain.start().compare(left, right, Util.argsSorter()).compare(left, right, Util.nameSorter()).result();
    }

    public static long queryParamValue(String uri, String queryParamName, long defaultValue) {
        try {
            URI parsed = new URI(uri);
            return Long.parseLong(Util.tokenizeQuery(parsed.getQuery()).computeIfAbsent(queryParamName, t -> String.valueOf(defaultValue)));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String injectQueryParam(String uri, String queryParamName, String queryParamValue) {
        try {
            URI parsed = new URI(uri);
            Map<String, String> params = Util.tokenizeQuery(parsed.getQuery());
            params.put(queryParamName, queryParamValue);
            StringBuilder sb = new StringBuilder();
            sb.append(parsed.getScheme()).append("://").append(parsed.getHost());
            if (parsed.getPort() != -1) {
                sb.append(':').append(parsed.getPort());
            }
            if (parsed.getPath() != null) {
                sb.append(parsed.getPath());
            }
            sb.append('?').append(QUERY_JOINER.join(params));
            return sb.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @VisibleForTesting
    static final class UriTokenizer {
        private static final Splitter PARAM_SPLITTER = Splitter.on((String)"&");

        private UriTokenizer() {
        }

        public static Map<String, String> tokenize(String queryParams) {
            LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
            Iterable paramTokens = PARAM_SPLITTER.split((CharSequence)(queryParams != null ? queryParams : ""));
            for (String tok : paramTokens) {
                String[] parts = tok.split("=");
                if ("".equals(parts[0])) continue;
                ret.put(parts[0], parts.length == 2 ? parts[1] : null);
            }
            LOG.trace("Tokenized : {} into {}", (Object)queryParams, ret);
            return ret;
        }
    }
}

