/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.protocol;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;

public class AuthorizedKeysDecoder {
    private static final String KEY_FACTORY_TYPE_RSA = "RSA";
    private static final String KEY_FACTORY_TYPE_DSA = "DSA";
    private static final String KEY_FACTORY_TYPE_ECDSA = "EC";
    private static final Map<String, String> ECDSA_CURVES = new HashMap<String, String>();
    private static final String ECDSA_SUPPORTED_CURVE_NAME = "nistp256";
    private static final String ECDSA_SUPPORTED_CURVE_NAME_SPEC;
    private static final String KEY_TYPE_RSA = "ssh-rsa";
    private static final String KEY_TYPE_DSA = "ssh-dss";
    private static final String KEY_TYPE_ECDSA = "ecdsa-sha2-nistp256";
    private byte[] bytes = new byte[0];
    private int pos = 0;

    public PublicKey decodePublicKey(String keyLine) throws GeneralSecurityException {
        this.bytes = Base64.getDecoder().decode(keyLine.getBytes(StandardCharsets.UTF_8));
        if (this.bytes.length == 0) {
            throw new IllegalArgumentException("No Base64 part to decode in " + keyLine);
        }
        this.pos = 0;
        String type = this.decodeType();
        if (type.equals(KEY_TYPE_RSA)) {
            return this.decodeAsRSA();
        }
        if (type.equals(KEY_TYPE_DSA)) {
            return this.decodeAsDSA();
        }
        if (type.equals(KEY_TYPE_ECDSA)) {
            return this.decodeAsEcDSA();
        }
        throw new IllegalArgumentException("Unknown decode key type " + type + " in " + keyLine);
    }

    private PublicKey decodeAsEcDSA() throws GeneralSecurityException {
        KeyFactory ecdsaFactory = SecurityUtils.getKeyFactory((String)KEY_FACTORY_TYPE_ECDSA);
        ECNamedCurveParameterSpec spec256r1 = ECNamedCurveTable.getParameterSpec((String)ECDSA_SUPPORTED_CURVE_NAME_SPEC);
        ECNamedCurveSpec params256r1 = new ECNamedCurveSpec(ECDSA_SUPPORTED_CURVE_NAME_SPEC, spec256r1.getCurve(), spec256r1.getG(), spec256r1.getN());
        ECPoint point = ECPointUtil.decodePoint((EllipticCurve)params256r1.getCurve(), (byte[])Arrays.copyOfRange(this.bytes, 39, this.bytes.length));
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(point, (ECParameterSpec)params256r1);
        return ecdsaFactory.generatePublic(pubKeySpec);
    }

    private PublicKey decodeAsDSA() throws GeneralSecurityException {
        KeyFactory dsaFactory = SecurityUtils.getKeyFactory((String)KEY_FACTORY_TYPE_DSA);
        BigInteger prime = this.decodeBigInt();
        BigInteger subPrime = this.decodeBigInt();
        BigInteger base = this.decodeBigInt();
        BigInteger publicKey = this.decodeBigInt();
        DSAPublicKeySpec spec = new DSAPublicKeySpec(publicKey, prime, subPrime, base);
        return dsaFactory.generatePublic(spec);
    }

    private PublicKey decodeAsRSA() throws GeneralSecurityException {
        KeyFactory rsaFactory = SecurityUtils.getKeyFactory((String)KEY_FACTORY_TYPE_RSA);
        BigInteger exponent = this.decodeBigInt();
        BigInteger modulus = this.decodeBigInt();
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
        return rsaFactory.generatePublic(spec);
    }

    private String decodeType() {
        int len = this.decodeInt();
        String type = new String(this.bytes, this.pos, len, StandardCharsets.UTF_8);
        this.pos += len;
        return type;
    }

    private int decodeInt() {
        return (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
    }

    private BigInteger decodeBigInt() {
        int len = this.decodeInt();
        byte[] bigIntBytes = new byte[len];
        System.arraycopy(this.bytes, this.pos, bigIntBytes, 0, len);
        this.pos += len;
        return new BigInteger(bigIntBytes);
    }

    public static String encodePublicKey(PublicKey publicKey) throws IOException {
        ByteArrayOutputStream byteOs = new ByteArrayOutputStream();
        if (publicKey.getAlgorithm().equals(KEY_FACTORY_TYPE_RSA) && publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            DataOutputStream dout = new DataOutputStream(byteOs);
            dout.writeInt(KEY_TYPE_RSA.getBytes(StandardCharsets.UTF_8).length);
            dout.write(KEY_TYPE_RSA.getBytes(StandardCharsets.UTF_8));
            dout.writeInt(rsaPublicKey.getPublicExponent().toByteArray().length);
            dout.write(rsaPublicKey.getPublicExponent().toByteArray());
            dout.writeInt(rsaPublicKey.getModulus().toByteArray().length);
            dout.write(rsaPublicKey.getModulus().toByteArray());
        } else if (publicKey.getAlgorithm().equals(KEY_FACTORY_TYPE_DSA) && publicKey instanceof DSAPublicKey) {
            DSAPublicKey dsaPublicKey = (DSAPublicKey)publicKey;
            DSAParams dsaParams = dsaPublicKey.getParams();
            DataOutputStream dout = new DataOutputStream(byteOs);
            dout.writeInt(KEY_TYPE_DSA.getBytes(StandardCharsets.UTF_8).length);
            dout.write(KEY_TYPE_DSA.getBytes(StandardCharsets.UTF_8));
            dout.writeInt(dsaParams.getP().toByteArray().length);
            dout.write(dsaParams.getP().toByteArray());
            dout.writeInt(dsaParams.getQ().toByteArray().length);
            dout.write(dsaParams.getQ().toByteArray());
            dout.writeInt(dsaParams.getG().toByteArray().length);
            dout.write(dsaParams.getG().toByteArray());
            dout.writeInt(dsaPublicKey.getY().toByteArray().length);
            dout.write(dsaPublicKey.getY().toByteArray());
        } else if (publicKey.getAlgorithm().equals(KEY_FACTORY_TYPE_ECDSA) && publicKey instanceof BCECPublicKey) {
            BCECPublicKey ecPublicKey = (BCECPublicKey)publicKey;
            DataOutputStream dout = new DataOutputStream(byteOs);
            dout.writeInt(KEY_TYPE_ECDSA.getBytes(StandardCharsets.UTF_8).length);
            dout.write(KEY_TYPE_ECDSA.getBytes(StandardCharsets.UTF_8));
            dout.writeInt(ECDSA_SUPPORTED_CURVE_NAME.getBytes(StandardCharsets.UTF_8).length);
            dout.write(ECDSA_SUPPORTED_CURVE_NAME.getBytes(StandardCharsets.UTF_8));
            byte[] coordX = ecPublicKey.getQ().getAffineXCoord().getEncoded();
            byte[] coordY = ecPublicKey.getQ().getAffineYCoord().getEncoded();
            dout.writeInt(coordX.length + coordY.length + 1);
            dout.writeByte(4);
            dout.write(coordX);
            dout.write(coordY);
        } else {
            throw new IllegalArgumentException("Unknown public key encoding: " + publicKey.getAlgorithm());
        }
        return Base64.getEncoder().encodeToString(byteOs.toByteArray());
    }

    static {
        ECDSA_CURVES.put(ECDSA_SUPPORTED_CURVE_NAME, "secp256r1");
        ECDSA_CURVES.put("nistp384", "secp384r1");
        ECDSA_CURVES.put("nistp512", "secp512r1");
        ECDSA_SUPPORTED_CURVE_NAME_SPEC = ECDSA_CURVES.get(ECDSA_SUPPORTED_CURVE_NAME);
    }
}

