/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.security.KeyPair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionImpl;

public abstract class CallHomeAuthorization {
    private static final CallHomeAuthorization REJECTED = new CallHomeAuthorization(){

        @Override
        public boolean isServerAllowed() {
            return false;
        }

        @Override
        protected String getSessionName() {
            return "";
        }

        @Override
        protected void applyTo(ClientSession session) {
            throw new IllegalStateException("Server is not allowed.");
        }
    };

    public static final CallHomeAuthorization rejected() {
        return REJECTED;
    }

    public static final Builder serverAccepted(String sessionName, String username) {
        return new Builder(sessionName, username);
    }

    public abstract boolean isServerAllowed();

    protected abstract void applyTo(ClientSession var1);

    protected abstract String getSessionName();

    private static class ServerAllowed
    extends CallHomeAuthorization {
        private final String nodeId;
        private final String username;
        private final Set<String> passwords;
        private final Set<KeyPair> clientKeyPair;

        ServerAllowed(String nodeId, String username, Collection<String> passwords, Collection<KeyPair> clientKeyPairs) {
            this.username = (String)Preconditions.checkNotNull((Object)username);
            this.passwords = ImmutableSet.copyOf(passwords);
            this.clientKeyPair = ImmutableSet.copyOf(clientKeyPairs);
            this.nodeId = (String)Preconditions.checkNotNull((Object)nodeId);
        }

        @Override
        protected String getSessionName() {
            return this.nodeId;
        }

        @Override
        public boolean isServerAllowed() {
            return true;
        }

        @Override
        protected void applyTo(ClientSession session) {
            Preconditions.checkArgument((boolean)(session instanceof ClientSessionImpl));
            session.setUsername(this.username);
            for (KeyPair keyPair : this.clientKeyPair) {
                session.addPublicKeyIdentity(keyPair);
            }
            for (String password : this.passwords) {
                session.addPasswordIdentity(password);
            }
        }
    }

    public static class Builder
    implements org.opendaylight.yangtools.concepts.Builder<CallHomeAuthorization> {
        private final String nodeId;
        private final String username;
        private final Set<String> passwords = new HashSet<String>();
        private final Set<KeyPair> clientKeys = new HashSet<KeyPair>();

        Builder(String nodeId, String username) {
            this.nodeId = (String)Preconditions.checkNotNull((Object)nodeId);
            this.username = (String)Preconditions.checkNotNull((Object)username);
        }

        public Builder addPassword(String password) {
            this.passwords.add(password);
            return this;
        }

        public Builder addClientKeys(KeyPair clientKey) {
            this.clientKeys.add(clientKey);
            return this;
        }

        public CallHomeAuthorization build() {
            return new ServerAllowed(this.nodeId, this.username, this.passwords, this.clientKeys);
        }
    }
}

