/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.protocol;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.future.SshFutureListener;
import org.opendaylight.netconf.callhome.protocol.CallHomeAuthorization;
import org.opendaylight.netconf.callhome.protocol.CallHomeNetconfSubsystemListener;
import org.opendaylight.netconf.callhome.protocol.CallHomeProtocolSessionContext;
import org.opendaylight.netconf.callhome.protocol.MinaSshNettyChannel;
import org.opendaylight.netconf.callhome.protocol.ReverseSshChannelInitializer;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.NetconfClientSessionNegotiatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CallHomeSessionContext
implements CallHomeProtocolSessionContext {
    private static final Logger LOG = LoggerFactory.getLogger(CallHomeSessionContext.class);
    static final AttributeRepository.AttributeKey<CallHomeSessionContext> SESSION_KEY = new AttributeRepository.AttributeKey();
    private static final String NETCONF = "netconf";
    private final ClientSessionImpl sshSession;
    private final CallHomeAuthorization authorization;
    private final Factory factory;
    private volatile MinaSshNettyChannel nettyChannel = null;
    private volatile boolean activated;
    private final InetSocketAddress remoteAddress;
    private final PublicKey serverKey;
    private boolean initialAuth = false;

    public boolean isInitialAuth() {
        return this.initialAuth;
    }

    public void setInitialAuth(boolean initialAuth) {
        this.initialAuth = initialAuth;
    }

    CallHomeSessionContext(ClientSession sshSession, CallHomeAuthorization authorization, SocketAddress remoteAddress, Factory factory) {
        this.authorization = (CallHomeAuthorization)Preconditions.checkNotNull((Object)authorization, (Object)"authorization");
        Preconditions.checkArgument((boolean)this.authorization.isServerAllowed(), (Object)"Server was not allowed.");
        Preconditions.checkArgument((boolean)(sshSession instanceof ClientSessionImpl), (Object)"sshSession must implement ClientSessionImpl");
        this.factory = (Factory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
        this.sshSession = (ClientSessionImpl)sshSession;
        this.sshSession.setAttribute(SESSION_KEY, (Object)this);
        this.remoteAddress = (InetSocketAddress)this.sshSession.getIoSession().getRemoteAddress();
        this.serverKey = this.sshSession.getKex().getServerKey();
    }

    static CallHomeSessionContext getFrom(ClientSession sshSession) {
        return (CallHomeSessionContext)sshSession.getAttribute(SESSION_KEY);
    }

    AuthFuture authorize() throws IOException {
        this.authorization.applyTo((ClientSession)this.sshSession);
        return this.sshSession.auth();
    }

    void openNetconfChannel() {
        LOG.debug("Opening NETCONF Subsystem on {}", (Object)this.sshSession);
        try {
            ChannelSubsystem netconfChannel = this.sshSession.createSubsystemChannel(NETCONF);
            netconfChannel.setStreaming(ClientChannel.Streaming.Async);
            netconfChannel.open().addListener(this.newSshFutureListener((ClientChannel)netconfChannel));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    SshFutureListener<OpenFuture> newSshFutureListener(ClientChannel netconfChannel) {
        return future -> {
            if (future.isOpened()) {
                this.netconfChannelOpened(netconfChannel);
            } else {
                this.channelOpenFailed(future.getException());
            }
        };
    }

    private void channelOpenFailed(Throwable throwable) {
        LOG.error("Unable to open netconf subsystem, disconnecting.", throwable);
        this.sshSession.close(false);
    }

    private void netconfChannelOpened(ClientChannel netconfChannel) {
        this.nettyChannel = this.newMinaSshNettyChannel(netconfChannel);
        this.factory.getChannelOpenListener().onNetconfSubsystemOpened(this, this::doActivate);
    }

    @GuardedBy(value="this")
    private synchronized Promise<NetconfClientSession> doActivate(NetconfClientSessionListener listener) {
        if (this.activated) {
            return CallHomeSessionContext.newSessionPromise().setFailure((Throwable)new IllegalStateException("Session already activated."));
        }
        this.activated = true;
        LOG.info("Activating Netconf channel for {} with {}", (Object)this.getRemoteAddress(), (Object)listener);
        Promise<NetconfClientSession> activationPromise = CallHomeSessionContext.newSessionPromise();
        this.factory.getChannelInitializer(listener).initialize((Channel)this.nettyChannel, activationPromise);
        this.factory.getNettyGroup().register((Channel)this.nettyChannel).awaitUninterruptibly(500L);
        return activationPromise;
    }

    protected MinaSshNettyChannel newMinaSshNettyChannel(ClientChannel netconfChannel) {
        return new MinaSshNettyChannel(this, (ClientSession)this.sshSession, netconfChannel);
    }

    private static Promise<NetconfClientSession> newSessionPromise() {
        return GlobalEventExecutor.INSTANCE.newPromise();
    }

    @Override
    public PublicKey getRemoteServerKey() {
        return this.serverKey;
    }

    @Override
    public String getRemoteServerVersion() {
        return this.sshSession.getServerVersion();
    }

    @Override
    public void terminate() {
        this.sshSession.close(false);
        this.removeSelf();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String getSessionName() {
        return this.authorization.getSessionName();
    }

    void removeSelf() {
        this.factory.remove(this);
    }

    static class Factory {
        private final EventLoopGroup nettyGroup;
        private final NetconfClientSessionNegotiatorFactory negotiatorFactory;
        private final CallHomeNetconfSubsystemListener subsystemListener;
        private final ConcurrentMap<String, CallHomeSessionContext> sessions = new ConcurrentHashMap<String, CallHomeSessionContext>();

        Factory(EventLoopGroup nettyGroup, NetconfClientSessionNegotiatorFactory negotiatorFactory, CallHomeNetconfSubsystemListener subsystemListener) {
            this.nettyGroup = (EventLoopGroup)Preconditions.checkNotNull((Object)nettyGroup, (Object)"nettyGroup");
            this.negotiatorFactory = (NetconfClientSessionNegotiatorFactory)Preconditions.checkNotNull((Object)negotiatorFactory, (Object)"negotiatorFactory");
            this.subsystemListener = (CallHomeNetconfSubsystemListener)Preconditions.checkNotNull((Object)subsystemListener);
        }

        void remove(CallHomeSessionContext session) {
            this.sessions.remove(session.getSessionName(), session);
        }

        ReverseSshChannelInitializer getChannelInitializer(NetconfClientSessionListener listener) {
            return ReverseSshChannelInitializer.create(this.negotiatorFactory, listener);
        }

        CallHomeNetconfSubsystemListener getChannelOpenListener() {
            return this.subsystemListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        CallHomeSessionContext createIfNotExists(ClientSession sshSession, CallHomeAuthorization authorization, SocketAddress remoteAddress) {
            Class<CallHomeSessionContext> clazz = CallHomeSessionContext.class;
            synchronized (CallHomeSessionContext.class) {
                CallHomeSessionContext session = (CallHomeSessionContext)this.sessions.get(authorization.getSessionName());
                if (session == null) {
                    session = new CallHomeSessionContext(sshSession, authorization, remoteAddress, this);
                    this.sessions.put(authorization.getSessionName(), session);
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return session;
            }
        }

        EventLoopGroup getNettyGroup() {
            return this.nettyGroup;
        }
    }
}

