/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.protocol;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.AbstractServerChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import java.net.SocketAddress;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.Closeable;
import org.opendaylight.netconf.callhome.protocol.CallHomeSessionContext;
import org.opendaylight.netconf.nettyutil.handler.ssh.client.AsyncSshHandlerReader;
import org.opendaylight.netconf.nettyutil.handler.ssh.client.AsyncSshHandlerWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinaSshNettyChannel
extends AbstractServerChannel {
    private static final Logger LOG = LoggerFactory.getLogger(MinaSshNettyChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private final ChannelConfig config = new DefaultChannelConfig((Channel)this);
    private final CallHomeSessionContext context;
    private final ClientSession session;
    private final ClientChannel sshChannel;
    private final AsyncSshHandlerReader sshReadHandler;
    private final AsyncSshHandlerWriter sshWriteAsyncHandler;
    private volatile boolean nettyClosed = false;

    MinaSshNettyChannel(CallHomeSessionContext context, ClientSession session, ClientChannel sshChannel) {
        this.context = (CallHomeSessionContext)Preconditions.checkNotNull((Object)context);
        this.session = (ClientSession)Preconditions.checkNotNull((Object)session);
        this.sshChannel = (ClientChannel)Preconditions.checkNotNull((Object)sshChannel);
        this.sshReadHandler = new AsyncSshHandlerReader((AutoCloseable)new ConnectionClosedDuringRead(), (AsyncSshHandlerReader.ReadMsgHandler)new FireReadMessage(), "netconf", sshChannel.getAsyncOut());
        this.sshWriteAsyncHandler = new AsyncSshHandlerWriter(sshChannel.getAsyncIn());
        this.pipeline().addFirst(new ChannelHandler[]{this.createChannelAdapter()});
    }

    private ChannelOutboundHandlerAdapter createChannelAdapter() {
        return new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                MinaSshNettyChannel.this.sshWriteAsyncHandler.write(ctx, msg, promise);
            }
        };
    }

    public ChannelConfig config() {
        return this.config;
    }

    private static boolean notClosing(Closeable sshCloseable) {
        return !sshCloseable.isClosing() && !sshCloseable.isClosed();
    }

    public boolean isOpen() {
        return MinaSshNettyChannel.notClosing((Closeable)this.session);
    }

    public boolean isActive() {
        return MinaSshNettyChannel.notClosing((Closeable)this.session);
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new SshUnsafe();
    }

    protected boolean isCompatible(EventLoop loop) {
        return true;
    }

    protected SocketAddress localAddress0() {
        return this.session.getIoSession().getLocalAddress();
    }

    protected SocketAddress remoteAddress0() {
        return this.context.getRemoteAddress();
    }

    protected void doBind(SocketAddress localAddress) {
        throw new UnsupportedOperationException("Bind not supported.");
    }

    void doMinaDisconnect(boolean blocking) {
        if (MinaSshNettyChannel.notClosing((Closeable)this.session)) {
            this.sshChannel.close(blocking);
            this.session.close(blocking);
        }
    }

    void doNettyDisconnect() {
        if (!this.nettyClosed) {
            this.nettyClosed = true;
            this.pipeline().fireChannelInactive();
            this.sshReadHandler.close();
            this.sshWriteAsyncHandler.close();
        }
    }

    protected void doDisconnect() {
        LOG.info("Disconnect invoked");
        this.doNettyDisconnect();
        this.doMinaDisconnect(false);
    }

    protected void doClose() {
        this.context.removeSelf();
        if (MinaSshNettyChannel.notClosing((Closeable)this.session)) {
            this.session.close(true);
            this.sshChannel.close(true);
        }
    }

    protected void doBeginRead() {
    }

    protected void doWrite(ChannelOutboundBuffer in) {
        throw new IllegalStateException("Outbound writes to SSH should be done by SSH Write handler");
    }

    private class SshUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private SshUnsafe() {
            super((AbstractChannel)MinaSshNettyChannel.this);
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            throw new UnsupportedOperationException("Unsafe is not supported.");
        }
    }

    private final class ConnectionClosedDuringRead
    implements AutoCloseable {
        private ConnectionClosedDuringRead() {
        }

        @Override
        public void close() {
            MinaSshNettyChannel.this.doNettyDisconnect();
        }
    }

    private final class FireReadMessage
    implements AsyncSshHandlerReader.ReadMsgHandler {
        private FireReadMessage() {
        }

        public void onMessageRead(ByteBuf msg) {
            MinaSshNettyChannel.this.pipeline().fireChannelRead((Object)msg);
        }
    }
}

