/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.callhome.protocol;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.Objects;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.SessionFactory;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.netty.NettyIoServiceFactory;
import org.opendaylight.netconf.callhome.protocol.CallHomeAuthorization;
import org.opendaylight.netconf.callhome.protocol.CallHomeAuthorizationProvider;
import org.opendaylight.netconf.callhome.protocol.CallHomeSessionContext;
import org.opendaylight.netconf.callhome.protocol.StatusRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfCallHomeServer
implements AutoCloseable,
ServerKeyVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfCallHomeServer.class);
    private final CallHomeAuthorizationProvider authProvider;
    private final IoServiceFactory serviceFactory;
    private final InetSocketAddress bindAddress;
    private final StatusRecorder recorder;
    private final CallHomeSessionContext.Factory sessionFactory;
    private final IoAcceptor acceptor;
    private final SshClient client;

    NetconfCallHomeServer(SshClient sshClient, CallHomeAuthorizationProvider authProvider, CallHomeSessionContext.Factory factory, InetSocketAddress socketAddress, StatusRecorder recorder) {
        this(sshClient, authProvider, factory, socketAddress, recorder, (IoServiceFactory)new NettyIoServiceFactory(factory.getNettyGroup()));
    }

    @VisibleForTesting
    NetconfCallHomeServer(SshClient sshClient, CallHomeAuthorizationProvider authProvider, CallHomeSessionContext.Factory factory, InetSocketAddress socketAddress, StatusRecorder recorder, IoServiceFactory serviceFactory) {
        this.client = Objects.requireNonNull(sshClient);
        this.authProvider = Objects.requireNonNull(authProvider);
        this.sessionFactory = Objects.requireNonNull(factory);
        this.bindAddress = socketAddress;
        this.recorder = recorder;
        this.serviceFactory = Objects.requireNonNull(serviceFactory);
        sshClient.setServerKeyVerifier((ServerKeyVerifier)this);
        sshClient.addSessionListener(this.createSessionListener());
        this.acceptor = serviceFactory.createAcceptor((IoHandler)new SessionFactory((ClientFactoryManager)sshClient));
    }

    @VisibleForTesting
    SshClient getClient() {
        return this.client;
    }

    SessionListener createSessionListener() {
        return new SessionListener(){

            public void sessionEvent(Session session, SessionListener.Event event) {
                ClientSession clientSession = (ClientSession)session;
                LOG.debug("SSH session {} event {}", (Object)session, (Object)event);
                switch (event) {
                    case KeyEstablished: {
                        NetconfCallHomeServer.this.doAuth(clientSession);
                        break;
                    }
                    case Authenticated: {
                        NetconfCallHomeServer.doPostAuth(clientSession);
                        break;
                    }
                }
            }

            public void sessionCreated(Session session) {
                LOG.debug("SSH session {} created", (Object)session);
            }

            public void sessionClosed(Session session) {
                CallHomeSessionContext ctx = CallHomeSessionContext.getFrom((ClientSession)session);
                if (ctx != null) {
                    ctx.removeSelf();
                }
                LOG.debug("SSH Session {} closed", (Object)session);
            }
        };
    }

    private static void doPostAuth(ClientSession session) {
        CallHomeSessionContext.getFrom(session).openNetconfChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAuth(ClientSession session) {
        try {
            Class<NetconfCallHomeServer> clazz = NetconfCallHomeServer.class;
            synchronized (NetconfCallHomeServer.class) {
                CallHomeSessionContext sessionContext = CallHomeSessionContext.getFrom(session);
                if (!sessionContext.isInitialAuth()) {
                    AuthFuture authFuture = CallHomeSessionContext.getFrom(session).authorize();
                    authFuture.addListener(this.newAuthSshFutureListener(session));
                    sessionContext.setInitialAuth(true);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            LOG.error("Failed to authorize session {}", (Object)session, (Object)e);
        }
        {
            return;
        }
    }

    private SshFutureListener<AuthFuture> newAuthSshFutureListener(final ClientSession session) {
        final PublicKey serverKey = session.getKex().getServerKey();
        return new SshFutureListener<AuthFuture>(){

            public void operationComplete(AuthFuture authFuture) {
                if (authFuture.isSuccess()) {
                    this.onSuccess();
                } else if (authFuture.isFailure()) {
                    this.onFailure(authFuture.getException());
                } else if (authFuture.isCanceled()) {
                    this.onCanceled();
                }
                authFuture.removeListener((SshFutureListener)this);
            }

            private void onSuccess() {
                LOG.debug("Authorize success");
            }

            private void onFailure(Throwable throwable) {
                LOG.error("Authorize failed for session {}", (Object)session, (Object)throwable);
                NetconfCallHomeServer.this.recorder.reportFailedAuth(serverKey);
                session.close(true);
            }

            private void onCanceled() {
                LOG.warn("Authorize cancelled");
                session.close(true);
            }
        };
    }

    public boolean verifyServerKey(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        CallHomeAuthorization authorization = this.authProvider.provideAuth(remoteAddress, serverKey);
        if (!authorization.isServerAllowed()) {
            LOG.info("Incoming session {} was rejected by Authorization Provider.", (Object)sshClientSession);
            return false;
        }
        CallHomeSessionContext session = this.sessionFactory.createIfNotExists(sshClientSession, authorization, remoteAddress);
        if (session != null) {
            return true;
        }
        LOG.info("Incoming session {} was rejected. Session with same name {} is already active.", (Object)sshClientSession, (Object)authorization.getSessionName());
        return false;
    }

    public void bind() throws IOException {
        try {
            this.client.start();
            this.acceptor.bind((SocketAddress)this.bindAddress);
        }
        catch (IOException e) {
            LOG.error("Unable to start NETCONF CallHome Service on {}", (Object)this.bindAddress, (Object)e);
            throw e;
        }
    }

    @Override
    public void close() {
        this.acceptor.close(true);
        this.serviceFactory.close(true);
    }
}

