/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jms.impl;

import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import org.ops4j.pax.transx.connection.ExceptionSorter;
import org.ops4j.pax.transx.connection.utils.AbstractManagedConnection;
import org.ops4j.pax.transx.connection.utils.CredentialExtractor;
import org.ops4j.pax.transx.jms.impl.ConnectionRequestInfoImpl;
import org.ops4j.pax.transx.jms.impl.ManagedConnectionFactoryImpl;
import org.ops4j.pax.transx.jms.impl.SessionImpl;
import org.ops4j.pax.transx.jms.impl.Utils;

public class ManagedConnectionImpl
extends AbstractManagedConnection<ManagedConnectionFactoryImpl, ManagedConnectionImpl, Session, SessionImpl>
implements ManagedConnection {
    private final XAConnection xaConnection;
    private final XASession xaSession;
    private final Session xaSessionSession;
    private final Connection connection;
    private final Session session;
    private final boolean xaSupport;

    public ManagedConnectionImpl(ManagedConnectionFactoryImpl mcf, Subject subject, ExceptionSorter exceptionSorter, ConnectionRequestInfoImpl cri) throws ResourceException {
        super(mcf, new CredentialExtractor(subject, cri, mcf), exceptionSorter);
        this.cri = cri;
        this.xaSupport = mcf.getXaConnectionFactory() != null;
        try {
            boolean transacted = cri != null && cri.isTransacted();
            int acknowledgeMode = 1;
            String userName = this.credentialExtractor.getUserName();
            String password = this.credentialExtractor.getPassword();
            if (userName != null && password != null) {
                this.xaConnection = this.xaSupport ? mcf.getXaConnectionFactory().createXAConnection(userName, password) : null;
                this.connection = this.xaSupport ? this.xaConnection : mcf.getConnectionFactory().createConnection(userName, password);
            } else {
                this.xaConnection = this.xaSupport ? mcf.getXaConnectionFactory().createXAConnection() : null;
                this.connection = this.xaSupport ? this.xaConnection : mcf.getConnectionFactory().createConnection();
            }
            this.connection.setExceptionListener(this::onException);
            this.session = this.connection.createSession(transacted, acknowledgeMode);
            if (this.xaSupport) {
                this.xaConnection.setExceptionListener(this::onException);
                this.xaSession = this.xaConnection.createXASession();
                this.xaSessionSession = this.xaSession.getSession();
                this.xaResource = this.xaSession.getXAResource();
            } else {
                this.xaSession = null;
                this.xaSessionSession = null;
                this.xaResource = null;
            }
        }
        catch (JMSException e) {
            throw new ResourceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Session getPhysicalConnection() {
        return this.getSession();
    }

    private Session getSession() {
        return this.inXaTransaction ? this.xaSessionSession : this.session;
    }

    ConnectionMetaData getConnectionMetaData() throws JMSException {
        return this.connection.getMetaData();
    }

    private void onException(JMSException exception) {
        ManagedConnectionImpl.safe(() -> this.connection.setExceptionListener(null), "Unable to unset exception listener");
        ManagedConnectionImpl.safe(() -> {
            if (this.xaSupport) {
                this.xaConnection.setExceptionListener(null);
            }
        }, "Unable to unset exception listener");
        this.unfilteredConnectionError((Exception)((Object)exception));
    }

    void start() throws JMSException {
        if (this.xaConnection != null) {
            this.xaConnection.start();
        }
        if (this.connection != null) {
            this.connection.start();
        }
    }

    void stop() throws JMSException {
        if (this.xaConnection != null) {
            this.xaConnection.stop();
        }
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    @Override
    protected void closePhysicalConnection() throws ResourceException {
        try {
            try {
                this.connection.close();
            }
            finally {
                if (this.xaConnection != null) {
                    this.xaConnection.close();
                }
            }
        }
        catch (JMSException e) {
            throw new ResourceException("Could not properly close the connection", (Throwable)e);
        }
    }

    @Override
    public void cleanup() throws ResourceException {
        super.cleanup();
        ManagedConnectionImpl.safe(() -> ((Connection)this.connection).stop(), "Error stopping connection");
        ManagedConnectionImpl.safe(() -> {
            if (this.xaSupport) {
                this.xaConnection.stop();
            }
        }, "Error stopping xaConnection");
        this.inXaTransaction = false;
    }

    @Override
    protected boolean isValid() {
        try {
            this.session.createMessage();
            this.connection.getMetaData();
            if (this.xaSupport) {
                this.xaSession.createMessage();
            }
            return true;
        }
        catch (JMSException e) {
            return false;
        }
    }

    @Override
    public LocalTransaction getLocalTransaction() throws ResourceException {
        return new LocalTransaction(){

            public void begin() throws ResourceException {
            }

            public void commit() throws ResourceException {
                try {
                    if (ManagedConnectionImpl.this.getSession().getTransacted()) {
                        ManagedConnectionImpl.this.getSession().commit();
                    }
                }
                catch (JMSException e) {
                    throw new ResourceException("Could not commit LocalTransaction", (Throwable)e);
                }
            }

            public void rollback() throws ResourceException {
                try {
                    if (ManagedConnectionImpl.this.getSession().getTransacted()) {
                        ManagedConnectionImpl.this.getSession().rollback();
                    }
                }
                catch (JMSException ex) {
                    throw new ResourceException("Could not rollback LocalTransaction", (Throwable)ex);
                }
            }
        };
    }

    private static void safe(Utils.RunnableWithException<JMSException> cb, String msg) {
        try {
            cb.run();
        }
        catch (JMSException e) {
            Utils.trace(msg, e);
        }
    }
}

