/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Destination;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Source;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.SupportingLink;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.LinkKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LinkBuilder
implements Builder<Link> {
    private Destination _destination;
    private LinkId _linkId;
    private Source _source;
    private List<SupportingLink> _supportingLink;
    private LinkKey key;
    Map<Class<? extends Augmentation<Link>>, Augmentation<Link>> augmentation = Collections.emptyMap();

    public LinkBuilder() {
    }

    public LinkBuilder(LinkAttributes arg) {
        this._linkId = arg.getLinkId();
        this._source = arg.getSource();
        this._destination = arg.getDestination();
        this._supportingLink = arg.getSupportingLink();
    }

    public LinkBuilder(Link base) {
        Map aug;
        this.key = base.key();
        this._linkId = base.getLinkId();
        this._destination = base.getDestination();
        this._source = base.getSource();
        this._supportingLink = base.getSupportingLink();
        if (base instanceof LinkImpl) {
            LinkImpl impl = (LinkImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Link>>, Augmentation<Link>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Link>>, Augmentation<Link>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LinkAttributes) {
            this._linkId = ((LinkAttributes)arg).getLinkId();
            this._source = ((LinkAttributes)arg).getSource();
            this._destination = ((LinkAttributes)arg).getDestination();
            this._supportingLink = ((LinkAttributes)arg).getSupportingLink();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkAttributes]");
    }

    public LinkKey key() {
        return this.key;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public LinkId getLinkId() {
        return this._linkId;
    }

    public Source getSource() {
        return this._source;
    }

    public List<SupportingLink> getSupportingLink() {
        return this._supportingLink;
    }

    public <E$$ extends Augmentation<Link>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public LinkBuilder withKey(LinkKey key) {
        this.key = key;
        return this;
    }

    public LinkBuilder setDestination(Destination value) {
        this._destination = value;
        return this;
    }

    public LinkBuilder setLinkId(LinkId value) {
        this._linkId = value;
        return this;
    }

    public LinkBuilder setSource(Source value) {
        this._source = value;
        return this;
    }

    public LinkBuilder setSupportingLink(List<SupportingLink> values) {
        this._supportingLink = values;
        return this;
    }

    public LinkBuilder addAugmentation(Class<? extends Augmentation<Link>> augmentationType, Augmentation<Link> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Link>>, Augmentation<Link>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LinkBuilder removeAugmentation(Class<? extends Augmentation<Link>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Link build() {
        return new LinkImpl(this);
    }

    private static final class LinkImpl
    implements Link {
        private final Destination _destination;
        private final LinkId _linkId;
        private final Source _source;
        private final List<SupportingLink> _supportingLink;
        private final LinkKey key;
        private Map<Class<? extends Augmentation<Link>>, Augmentation<Link>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        LinkImpl(LinkBuilder base) {
            this.key = base.key() != null ? base.key() : new LinkKey(base.getLinkId());
            this._linkId = this.key.getLinkId();
            this._destination = base.getDestination();
            this._source = base.getSource();
            this._supportingLink = base.getSupportingLink();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Link> getImplementedInterface() {
            return Link.class;
        }

        @Override
        public LinkKey key() {
            return this.key;
        }

        @Override
        public Destination getDestination() {
            return this._destination;
        }

        @Override
        public LinkId getLinkId() {
            return this._linkId;
        }

        @Override
        public Source getSource() {
            return this._source;
        }

        @Override
        public List<SupportingLink> getSupportingLink() {
            return this._supportingLink;
        }

        public <E$$ extends Augmentation<Link>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._destination);
            result = 31 * result + Objects.hashCode(this._linkId);
            result = 31 * result + Objects.hashCode(this._source);
            result = 31 * result + Objects.hashCode(this._supportingLink);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Link.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Link other = (Link)obj;
            if (!Objects.equals(this._destination, other.getDestination())) {
                return false;
            }
            if (!Objects.equals(this._linkId, other.getLinkId())) {
                return false;
            }
            if (!Objects.equals(this._source, other.getSource())) {
                return false;
            }
            if (!Objects.equals(this._supportingLink, other.getSupportingLink())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LinkImpl otherImpl = (LinkImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Link>>, Augmentation<Link>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Link");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_destination", (Object)this._destination);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_linkId", (Object)this._linkId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_source", (Object)this._source);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_supportingLink", this._supportingLink);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

