/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.context;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import org.ops4j.pax.cdi.api.SingletonScoped;
import org.ops4j.pax.cdi.extension.impl.context.SingletonScopeContextEntry;

@Typed
public class SingletonScopeContext
implements AlterableContext {
    private Map<Contextual<?>, SingletonScopeContextEntry<?>> serviceBeans = new ConcurrentHashMap();
    private CreationalContext<Object> cc;

    public SingletonScopeContext(BeanManager beanManager) {
        this.cc = beanManager.createCreationalContext(null);
    }

    public Class<? extends Annotation> getScope() {
        return SingletonScoped.class;
    }

    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        SingletonScopeContextEntry<Object> serviceBean = this.serviceBeans.get(component);
        if (serviceBean != null) {
            return (T)serviceBean.getContextualInstance();
        }
        Object instance = component.create(creationalContext);
        serviceBean = new SingletonScopeContextEntry<Object>(component, instance, creationalContext);
        this.serviceBeans.put(component, serviceBean);
        return (T)instance;
    }

    public <T> T get(Contextual<T> component) {
        SingletonScopeContextEntry<?> serviceBean = this.serviceBeans.get(component);
        if (serviceBean != null) {
            return (T)serviceBean.getContextualInstance();
        }
        return null;
    }

    public void destroy(Contextual<?> component) {
        SingletonScopeContextEntry<?> serviceBean = this.serviceBeans.remove(component);
        if (serviceBean != null) {
            Object instance = serviceBean.getContextualInstance();
            serviceBean.getBean().destroy(instance, serviceBean.getCreationalContext());
        }
    }

    public boolean isActive() {
        return true;
    }

    public <S> CreationalContext<S> getCreationalContext() {
        return this.cc;
    }
}

