/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.osgi;

import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.bundle.core.BundleStateService;
import org.ops4j.pax.cdi.extension.api.runtime.dto.ComponentConfigurationDTO;
import org.ops4j.pax.cdi.extension.api.runtime.dto.ComponentDescriptionDTO;
import org.ops4j.pax.cdi.extension.api.runtime.dto.UnsatisfiedReferenceDTO;
import org.ops4j.pax.cdi.extension.impl.osgi.Registry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class CdiBundleState
implements BundleStateService {
    private final Registry registry;

    public static ServiceRegistration<?> register(BundleContext context) {
        return context.registerService(BundleStateService.class, (Object)new CdiBundleState(Registry.getInstance()), null);
    }

    public CdiBundleState(Registry registry) {
        this.registry = registry;
    }

    public String getName() {
        return "CdiOsgi";
    }

    public String getDiag(Bundle bundle) {
        StringBuilder sb = new StringBuilder();
        for (ComponentDescriptionDTO desc : this.registry.getComponentDescriptionDTOs(bundle)) {
            for (ComponentConfigurationDTO cfg : this.registry.getComponentConfigurationDTOs(desc)) {
                if (cfg.state == 8 || cfg.state == 4) continue;
                sb.append(cfg.description.name).append(" (").append(cfg.id).append(")\n");
                if ((cfg.state & 1) != 0) {
                    sb.append("  missing configurations:\n");
                    for (String string : cfg.description.configurationPid) {
                        sb.append("    ").append(string).append("\n");
                    }
                }
                if ((cfg.state & 2) == 0) continue;
                sb.append("  missing references:\n");
                for (UnsatisfiedReferenceDTO unsatisfiedReferenceDTO : cfg.unsatisfiedReferences) {
                    sb.append("    ").append(unsatisfiedReferenceDTO.name).append("\n");
                }
            }
        }
        return sb.toString();
    }

    public BundleState getState(Bundle bundle) {
        if (bundle.getState() == 32) {
            for (ComponentDescriptionDTO desc : this.registry.getComponentDescriptionDTOs(bundle)) {
                for (ComponentConfigurationDTO cfg : this.registry.getComponentConfigurationDTOs(desc)) {
                    if (cfg.state == 8 || cfg.state == 4) continue;
                    return BundleState.Waiting;
                }
            }
        }
        return BundleState.Unknown;
    }
}

