/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.osgi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.impl.manager.ComponentHolder;
import org.apache.felix.scr.impl.manager.ComponentManager;
import org.apache.felix.scr.impl.manager.ReferenceManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.ops4j.pax.cdi.extension.api.runtime.CdiOsgiRuntime;
import org.ops4j.pax.cdi.extension.api.runtime.dto.ComponentConfigurationDTO;
import org.ops4j.pax.cdi.extension.api.runtime.dto.ComponentDescriptionDTO;
import org.ops4j.pax.cdi.extension.api.runtime.dto.ReferenceDTO;
import org.ops4j.pax.cdi.extension.api.runtime.dto.SatisfiedReferenceDTO;
import org.ops4j.pax.cdi.extension.api.runtime.dto.UnsatisfiedReferenceDTO;
import org.ops4j.pax.cdi.extension.impl.component2.ComponentRegistry;
import org.osgi.dto.DTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.BundleDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;

public class Registry
implements CdiOsgiRuntime {
    private static final String[] EMPTY = new String[0];
    private static final Registry INSTANCE = new Registry();
    private final List<ComponentRegistry> registries = new CopyOnWriteArrayList<ComponentRegistry>();

    public static Registry getInstance() {
        return INSTANCE;
    }

    private Registry() {
    }

    public void register(ComponentRegistry componentRegistry) {
        if (!this.registries.contains(componentRegistry)) {
            this.registries.add(componentRegistry);
        }
    }

    public void unregister(ComponentRegistry componentRegistry) {
        this.registries.remove(componentRegistry);
    }

    @Override
    public Collection<ComponentDescriptionDTO> getComponentDescriptionDTOs(Bundle ... bundles) {
        ArrayList<ComponentDescriptionDTO> dtos = new ArrayList<ComponentDescriptionDTO>();
        for (ComponentRegistry registry : this.registries) {
            Bundle bundle = registry.getBundleContext().getBundle();
            if (bundles.length != 0 && !Arrays.asList(bundles).contains(bundle)) continue;
            for (ComponentHolder<?> holder : registry.getComponentHolders()) {
                dtos.add(this.holderToDescription(holder));
            }
        }
        return dtos;
    }

    @Override
    public ComponentDescriptionDTO getComponentDescriptionDTO(Bundle bundle, String name) {
        return this.getComponentDescriptionDTO(bundle.getBundleId(), name);
    }

    @Override
    public Collection<ComponentConfigurationDTO> getComponentConfigurationDTOs(ComponentDescriptionDTO description) {
        if (description == null) {
            return Collections.emptyList();
        }
        ComponentHolder<?> holder = this.getHolderFromDescription(description);
        if (holder == null) {
            return Collections.emptyList();
        }
        description = this.holderToDescription(holder);
        List<ComponentManager<?>> managers = holder.getComponents();
        ArrayList<ComponentConfigurationDTO> result = new ArrayList<ComponentConfigurationDTO>(managers.size());
        for (ComponentManager<?> manager : managers) {
            result.add(this.managerToConfiguration(manager, description));
        }
        return result;
    }

    private ComponentHolder<?> getHolderFromDescription(ComponentDescriptionDTO description) {
        if (description.bundle == null) {
            throw new IllegalArgumentException("No bundle supplied in ComponentDescriptionDTO named " + description.name);
        }
        long bundleId = description.bundle.id;
        for (ComponentRegistry registry : this.registries) {
            if (registry.getBundleContext().getBundle().getBundleId() != bundleId) continue;
            return registry.getComponentHolder(description.name);
        }
        return null;
    }

    private ComponentDescriptionDTO getComponentDescriptionDTO(long bundleId, String name) {
        for (ComponentRegistry registry : this.registries) {
            ComponentHolder<?> holder;
            if (registry.getBundleContext().getBundle().getBundleId() != bundleId || (holder = registry.getComponentHolder(name)) == null) continue;
            return this.holderToDescription(holder);
        }
        return null;
    }

    private ComponentDescriptionDTO holderToDescription(ComponentHolder<?> holder) {
        ComponentDescriptionDTO dto = new ComponentDescriptionDTO();
        ComponentMetadata m = holder.getComponentMetadata();
        dto.activate = m.getActivate();
        dto.bundle = this.bundleToDTO(holder.getActivator().getBundleContext());
        dto.configurationPid = m.getConfigurationPid().toArray(new String[m.getConfigurationPid().size()]);
        dto.configurationPolicy = m.getConfigurationPolicy();
        dto.deactivate = m.getDeactivate();
        dto.defaultEnabled = m.isEnabled();
        dto.factory = m.getFactoryIdentifier();
        dto.immediate = m.isImmediate();
        dto.implementationClass = m.getImplementationClassName();
        dto.modified = m.getModified();
        dto.name = m.getName();
        dto.properties = this.deepCopy(m.getProperties());
        dto.references = this.refsToDTO(m.getDependencies());
        dto.scope = m.getServiceMetadata() == null ? null : m.getServiceMetadata().getScope().name();
        dto.serviceInterfaces = m.getServiceMetadata() == null ? EMPTY : m.getServiceMetadata().getProvides();
        return dto;
    }

    private Map<String, Object> deepCopy(Map<String, Object> source) {
        HashMap<String, Object> result = new HashMap<String, Object>(source.size());
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            result.put(entry.getKey(), this.convert(entry.getValue()));
        }
        return result;
    }

    private Map<String, Object> deepCopy(ServiceReference<?> source) {
        String[] keys = source.getPropertyKeys();
        HashMap<String, Object> result = new HashMap<String, Object>(keys.length);
        for (String key : keys) {
            result.put(key, this.convert(source.getProperty(key)));
        }
        return result;
    }

    Object convert(Object source) {
        if (source.getClass().isArray()) {
            Class<?> type = source.getClass().getComponentType();
            if (this.checkType(type)) {
                return source;
            }
            return String.valueOf(source);
        }
        if (this.checkType(source.getClass())) {
            return source;
        }
        return String.valueOf(source);
    }

    boolean checkType(Class<?> type) {
        if (type == String.class) {
            return true;
        }
        if (type == Boolean.class) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        return DTO.class.isAssignableFrom(type);
    }

    private ReferenceDTO[] refsToDTO(List<ReferenceMetadata> dependencies) {
        ReferenceDTO[] dtos = new ReferenceDTO[dependencies.size()];
        int i = 0;
        for (ReferenceMetadata r : dependencies) {
            ReferenceDTO dto = new ReferenceDTO();
            dto.bind = r.getBind();
            dto.cardinality = r.getCardinality();
            dto.field = r.getField();
            dto.fieldOption = r.getFieldOption();
            dto.interfaceName = r.getInterface();
            dto.name = r.getName();
            dto.policy = r.getPolicy();
            dto.policyOption = r.getPolicyOption();
            dto.scope = r.getScope().name();
            dto.target = r.getTarget();
            dto.unbind = r.getUnbind();
            dto.updated = r.getUpdated();
            dtos[i++] = dto;
        }
        return dtos;
    }

    private BundleDTO bundleToDTO(BundleContext bundleContext) {
        if (bundleContext == null) {
            return null;
        }
        Bundle bundle = bundleContext.getBundle();
        if (bundle == null) {
            return null;
        }
        BundleDTO b = new BundleDTO();
        b.id = bundle.getBundleId();
        b.lastModified = bundle.getLastModified();
        b.state = bundle.getState();
        b.symbolicName = bundle.getSymbolicName();
        b.version = bundle.getVersion().toString();
        return b;
    }

    private ComponentConfigurationDTO managerToConfiguration(ComponentManager<?> manager, ComponentDescriptionDTO description) {
        ComponentConfigurationDTO dto = new ComponentConfigurationDTO();
        dto.satisfiedReferences = this.satisfiedRefManagersToDTO(manager.getReferenceManagers());
        dto.unsatisfiedReferences = this.unsatisfiedRefManagersToDTO(manager.getReferenceManagers());
        dto.description = description;
        dto.id = manager.getId();
        dto.properties = new HashMap<String, Object>(manager.getProperties());
        dto.state = manager.getSpecState();
        return dto;
    }

    private SatisfiedReferenceDTO[] satisfiedRefManagersToDTO(List<? extends ReferenceManager<?, ?>> referenceManagers) {
        ArrayList<SatisfiedReferenceDTO> dtos = new ArrayList<SatisfiedReferenceDTO>();
        for (ReferenceManager<?, ?> ref : referenceManagers) {
            if (!ref.isSatisfied()) continue;
            SatisfiedReferenceDTO dto = new SatisfiedReferenceDTO();
            dto.name = ref.getName();
            dto.target = ref.getTarget();
            List<ServiceReference<?>> serviceRefs = ref.getServiceReferences();
            ServiceReferenceDTO[] srDTOs = new ServiceReferenceDTO[serviceRefs.size()];
            int j = 0;
            for (ServiceReference<?> serviceRef : serviceRefs) {
                ServiceReferenceDTO srefDTO = this.serviceReferenceToDTO(serviceRef);
                if (srefDTO == null) continue;
                srDTOs[j++] = srefDTO;
            }
            dto.boundServices = srDTOs;
            dtos.add(dto);
        }
        return dtos.toArray(new SatisfiedReferenceDTO[dtos.size()]);
    }

    private UnsatisfiedReferenceDTO[] unsatisfiedRefManagersToDTO(List<? extends ReferenceManager<?, ?>> referenceManagers) {
        ArrayList<UnsatisfiedReferenceDTO> dtos = new ArrayList<UnsatisfiedReferenceDTO>();
        for (ReferenceManager<?, ?> ref : referenceManagers) {
            if (ref.isSatisfied()) continue;
            UnsatisfiedReferenceDTO dto = new UnsatisfiedReferenceDTO();
            dto.name = ref.getName();
            dto.target = ref.getTarget();
            List<ServiceReference<?>> serviceRefs = ref.getServiceReferences();
            ServiceReferenceDTO[] srDTOs = new ServiceReferenceDTO[serviceRefs.size()];
            int j = 0;
            for (ServiceReference<?> serviceRef : serviceRefs) {
                ServiceReferenceDTO srefDTO = this.serviceReferenceToDTO(serviceRef);
                if (srefDTO == null) continue;
                srDTOs[j++] = srefDTO;
            }
            dto.targetServices = srDTOs;
            dtos.add(dto);
        }
        return dtos.toArray(new UnsatisfiedReferenceDTO[dtos.size()]);
    }

    private ServiceReferenceDTO serviceReferenceToDTO(ServiceReference<?> serviceRef) {
        if (serviceRef == null) {
            return null;
        }
        ServiceReferenceDTO dto = new ServiceReferenceDTO();
        Bundle bundle = serviceRef.getBundle();
        dto.bundle = bundle != null ? bundle.getBundleId() : -1L;
        dto.id = (Long)serviceRef.getProperty("service.id");
        dto.properties = this.deepCopy(serviceRef);
        Bundle[] usingBundles = serviceRef.getUsingBundles();
        if (usingBundles != null) {
            long[] usingBundleIds = new long[usingBundles.length];
            for (int i = 0; i < usingBundles.length; ++i) {
                usingBundleIds[i] = usingBundles[i].getBundleId();
            }
            dto.usingBundles = usingBundleIds;
        }
        return dto;
    }
}

