/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.support;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class PrivateRegistryWrapper
implements BundleContext {
    public static final String PRIVATE = "org.ops4j.pax.cdi.private";
    private final BundleContext delegate;
    private final List<PrivateServiceRegistration<?>> registrations = new CopyOnWriteArrayList();
    private final List<ListenerInfo> listeners = new CopyOnWriteArrayList<ListenerInfo>();
    private final AtomicLong privateServiceId = new AtomicLong(0L);

    public PrivateRegistryWrapper(BundleContext bundleContext) {
        this.delegate = bundleContext;
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        if (filter != null && filter.contains(PRIVATE)) {
            this.addPrivateServiceListener(listener, filter);
        } else {
            this.delegate.addServiceListener(listener, filter);
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        this.removePrivateServiceListener(listener);
        this.delegate.removeServiceListener(listener);
    }

    public ServiceReference<?>[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        if (filter != null && filter.contains(PRIVATE)) {
            return this.getPrivateServiceReferences(clazz, filter);
        }
        return this.delegate.getServiceReferences(clazz, filter);
    }

    public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        if (properties != null && properties.get(PRIVATE) != null) {
            return this.registerPrivate(clazzes, service, properties);
        }
        return this.delegate.registerService(clazzes, service, properties);
    }

    public <S> S getService(ServiceReference<S> reference) {
        if (reference instanceof PrivateServiceRegistration) {
            return this.getPrivateService(reference);
        }
        return (S)this.delegate.getService(reference);
    }

    public boolean ungetService(ServiceReference<?> reference) {
        if (reference instanceof PrivateServiceRegistration) {
            return this.ungetPrivateService(reference);
        }
        return this.delegate.ungetService(reference);
    }

    private void addPrivateServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        Filter flt = this.delegate.createFilter(filter);
        this.listeners.add(new ListenerInfo(listener, flt));
    }

    private void removePrivateServiceListener(ServiceListener listener) {
        this.listeners.removeIf(listenerInfo -> listenerInfo.listener == listener);
    }

    private <S> ServiceRegistration<S> registerPrivate(String[] clazzes, Object svc, Dictionary<String, ?> properties) {
        PrivateServiceRegistration reg = new PrivateServiceRegistration(clazzes, svc, properties);
        this.registrations.add(reg);
        ServiceEvent event = new ServiceEvent(1, reg);
        for (ListenerInfo li : this.listeners) {
            if (!li.filter.match(reg)) continue;
            li.listener.serviceChanged(event);
        }
        return reg;
    }

    private ServiceReference<?>[] getPrivateServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        Filter flt = this.delegate.createFilter(clazz != null ? "(&(objectClass=" + clazz + ")" + filter + ")" : filter);
        ArrayList refs = new ArrayList();
        for (PrivateServiceRegistration<?> reg : this.registrations) {
            if (!flt.match(reg)) continue;
            refs.add(reg);
        }
        return refs.toArray(new ServiceReference[refs.size()]);
    }

    private <S> S getPrivateService(ServiceReference<S> reference) {
        PrivateServiceRegistration reg = (PrivateServiceRegistration)reference;
        if (reg.service instanceof ServiceFactory) {
            return (S)((ServiceFactory)reg.service).getService(this.getBundle(), (ServiceRegistration)reg);
        }
        return (S)reg.service;
    }

    private <S> void unregisterPrivate(PrivateServiceRegistration<S> reg) {
        this.registrations.remove(reg);
        ServiceEvent event = new ServiceEvent(4, reg);
        for (ListenerInfo li : this.listeners) {
            if (!li.filter.match(reg)) continue;
            li.listener.serviceChanged(event);
        }
    }

    private boolean ungetPrivateService(ServiceReference<?> reference) {
        return false;
    }

    public void addServiceListener(ServiceListener listener) {
        this.delegate.addServiceListener(listener);
    }

    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        return this.delegate.registerService(clazz, service, properties);
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        return this.delegate.registerService(clazz, service, properties);
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, ServiceFactory<S> factory, Dictionary<String, ?> properties) {
        return this.delegate.registerService(clazz, factory, properties);
    }

    public ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.delegate.getAllServiceReferences(clazz, filter);
    }

    public ServiceReference<?> getServiceReference(String clazz) {
        return this.delegate.getServiceReference(clazz);
    }

    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        return this.delegate.getServiceReference(clazz);
    }

    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        return this.delegate.getServiceReferences(clazz, filter);
    }

    public <S> ServiceObjects<S> getServiceObjects(ServiceReference<S> reference) {
        return this.delegate.getServiceObjects(reference);
    }

    public String getProperty(String key) {
        return this.delegate.getProperty(key);
    }

    public Bundle getBundle() {
        return this.delegate.getBundle();
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        return this.delegate.installBundle(location, input);
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.delegate.installBundle(location);
    }

    public Bundle getBundle(long id) {
        return this.delegate.getBundle(id);
    }

    public Bundle[] getBundles() {
        return this.delegate.getBundles();
    }

    public void addBundleListener(BundleListener listener) {
        this.delegate.addBundleListener(listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.delegate.removeBundleListener(listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.delegate.addFrameworkListener(listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.delegate.removeFrameworkListener(listener);
    }

    public File getDataFile(String filename) {
        return this.delegate.getDataFile(filename);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return this.delegate.createFilter(filter);
    }

    public Bundle getBundle(String location) {
        return this.delegate.getBundle(location);
    }

    class PrivateServiceRegistration<S>
    implements ServiceRegistration<S>,
    ServiceReference<S> {
        private final Hashtable<String, ?> properties;
        private final Object service;

        public PrivateServiceRegistration(String[] clazzes, Object svc, Dictionary<String, ?> properties) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            Enumeration<String> elem = properties.keys();
            while (elem.hasMoreElements()) {
                String key = elem.nextElement();
                props.put(key, properties.get(key));
            }
            props.put("objectClass", clazzes);
            props.put("service.id", PrivateRegistryWrapper.this.privateServiceId.decrementAndGet());
            this.properties = props;
            this.service = svc;
        }

        public ServiceReference<S> getReference() {
            return this;
        }

        public void setProperties(Dictionary<String, ?> properties) {
            throw new UnsupportedOperationException();
        }

        public void unregister() {
            PrivateRegistryWrapper.this.unregisterPrivate(this);
        }

        public Object getProperty(String key) {
            return this.properties.get(key);
        }

        public String[] getPropertyKeys() {
            Set<String> keys = this.properties.keySet();
            return keys.toArray(new String[keys.size()]);
        }

        public Bundle getBundle() {
            throw new UnsupportedOperationException();
        }

        public Bundle[] getUsingBundles() {
            throw new UnsupportedOperationException();
        }

        public boolean isAssignableTo(Bundle bundle, String className) {
            return true;
        }

        public int compareTo(Object reference) {
            Integer otherRank;
            Long otherId;
            ServiceReference other = (ServiceReference)reference;
            Long id = (Long)this.getProperty("service.id");
            if (id.equals(otherId = (Long)other.getProperty("service.id"))) {
                return 0;
            }
            Object rankObj = this.getProperty("service.ranking");
            Object otherRankObj = other.getProperty("service.ranking");
            rankObj = rankObj == null ? new Integer(0) : rankObj;
            otherRankObj = otherRankObj == null ? new Integer(0) : otherRankObj;
            Integer rank = rankObj instanceof Integer ? (Integer)rankObj : new Integer(0);
            Integer n = otherRank = otherRankObj instanceof Integer ? (Integer)otherRankObj : new Integer(0);
            if (rank.compareTo(otherRank) < 0) {
                return -1;
            }
            if (rank.compareTo(otherRank) > 0) {
                return 1;
            }
            return id.compareTo(otherId) < 0 ? 1 : -1;
        }
    }

    static class ListenerInfo {
        final ServiceListener listener;
        final Filter filter;

        public ListenerInfo(ServiceListener listener, Filter filter) {
            this.listener = listener;
            this.filter = filter;
        }
    }
}

