/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.AclBase;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.Acl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.AclKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.AccessListEntries;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.AclOperData;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AclBuilder
implements Builder<Acl> {
    private AccessListEntries _accessListEntries;
    private String _aclName;
    private AclOperData _aclOperData;
    private Class<? extends AclBase> _aclType;
    private AclKey key;
    Map<Class<? extends Augmentation<Acl>>, Augmentation<Acl>> augmentation = Collections.emptyMap();

    public AclBuilder() {
    }

    public AclBuilder(Acl base) {
        Map aug;
        this.key = base.key();
        this._aclName = base.getAclName();
        this._aclType = base.getAclType();
        this._accessListEntries = base.getAccessListEntries();
        this._aclOperData = base.getAclOperData();
        if (base instanceof AclImpl) {
            AclImpl impl = (AclImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Acl>>, Augmentation<Acl>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Acl>>, Augmentation<Acl>>(aug);
        }
    }

    public AclKey key() {
        return this.key;
    }

    public AccessListEntries getAccessListEntries() {
        return this._accessListEntries;
    }

    public String getAclName() {
        return this._aclName;
    }

    public AclOperData getAclOperData() {
        return this._aclOperData;
    }

    public Class<? extends AclBase> getAclType() {
        return this._aclType;
    }

    public <E$$ extends Augmentation<Acl>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AclBuilder withKey(AclKey key) {
        this.key = key;
        return this;
    }

    public AclBuilder setAccessListEntries(AccessListEntries value) {
        this._accessListEntries = value;
        return this;
    }

    public AclBuilder setAclName(String value) {
        this._aclName = value;
        return this;
    }

    public AclBuilder setAclOperData(AclOperData value) {
        this._aclOperData = value;
        return this;
    }

    public AclBuilder setAclType(Class<? extends AclBase> value) {
        this._aclType = value;
        return this;
    }

    public AclBuilder addAugmentation(Class<? extends Augmentation<Acl>> augmentationType, Augmentation<Acl> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Acl>>, Augmentation<Acl>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AclBuilder removeAugmentation(Class<? extends Augmentation<Acl>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Acl build() {
        return new AclImpl(this);
    }

    private static final class AclImpl
    implements Acl {
        private final AccessListEntries _accessListEntries;
        private final String _aclName;
        private final AclOperData _aclOperData;
        private final Class<? extends AclBase> _aclType;
        private final AclKey key;
        private Map<Class<? extends Augmentation<Acl>>, Augmentation<Acl>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        AclImpl(AclBuilder base) {
            this.key = base.key() != null ? base.key() : new AclKey(base.getAclName(), base.getAclType());
            this._aclName = this.key.getAclName();
            this._aclType = this.key.getAclType();
            this._accessListEntries = base.getAccessListEntries();
            this._aclOperData = base.getAclOperData();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Acl> getImplementedInterface() {
            return Acl.class;
        }

        @Override
        public AclKey key() {
            return this.key;
        }

        @Override
        public AccessListEntries getAccessListEntries() {
            return this._accessListEntries;
        }

        @Override
        public String getAclName() {
            return this._aclName;
        }

        @Override
        public AclOperData getAclOperData() {
            return this._aclOperData;
        }

        @Override
        public Class<? extends AclBase> getAclType() {
            return this._aclType;
        }

        public <E$$ extends Augmentation<Acl>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._accessListEntries);
            result = 31 * result + Objects.hashCode(this._aclName);
            result = 31 * result + Objects.hashCode(this._aclOperData);
            result = 31 * result + Objects.hashCode(this._aclType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Acl.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Acl other = (Acl)obj;
            if (!Objects.equals(this._accessListEntries, other.getAccessListEntries())) {
                return false;
            }
            if (!Objects.equals(this._aclName, other.getAclName())) {
                return false;
            }
            if (!Objects.equals(this._aclOperData, other.getAclOperData())) {
                return false;
            }
            if (!Objects.equals(this._aclType, other.getAclType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AclImpl otherImpl = (AclImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Acl>>, Augmentation<Acl>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Acl");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_accessListEntries", (Object)this._accessListEntries);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_aclName", (Object)this._aclName);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_aclOperData", (Object)this._aclOperData);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_aclType", this._aclType);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

