/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.Ace;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.AceKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.AceOperData;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.Actions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.Matches;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AceBuilder
implements Builder<Ace> {
    private AceOperData _aceOperData;
    private Actions _actions;
    private Matches _matches;
    private String _ruleName;
    private AceKey key;
    Map<Class<? extends Augmentation<Ace>>, Augmentation<Ace>> augmentation = Collections.emptyMap();

    public AceBuilder() {
    }

    public AceBuilder(Ace base) {
        Map aug;
        this.key = base.key();
        this._ruleName = base.getRuleName();
        this._aceOperData = base.getAceOperData();
        this._actions = base.getActions();
        this._matches = base.getMatches();
        if (base instanceof AceImpl) {
            AceImpl impl = (AceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ace>>, Augmentation<Ace>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ace>>, Augmentation<Ace>>(aug);
        }
    }

    public AceKey key() {
        return this.key;
    }

    public AceOperData getAceOperData() {
        return this._aceOperData;
    }

    public Actions getActions() {
        return this._actions;
    }

    public Matches getMatches() {
        return this._matches;
    }

    public String getRuleName() {
        return this._ruleName;
    }

    public <E$$ extends Augmentation<Ace>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AceBuilder withKey(AceKey key) {
        this.key = key;
        return this;
    }

    public AceBuilder setAceOperData(AceOperData value) {
        this._aceOperData = value;
        return this;
    }

    public AceBuilder setActions(Actions value) {
        this._actions = value;
        return this;
    }

    public AceBuilder setMatches(Matches value) {
        this._matches = value;
        return this;
    }

    public AceBuilder setRuleName(String value) {
        this._ruleName = value;
        return this;
    }

    public AceBuilder addAugmentation(Class<? extends Augmentation<Ace>> augmentationType, Augmentation<Ace> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ace>>, Augmentation<Ace>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AceBuilder removeAugmentation(Class<? extends Augmentation<Ace>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ace build() {
        return new AceImpl(this);
    }

    private static final class AceImpl
    implements Ace {
        private final AceOperData _aceOperData;
        private final Actions _actions;
        private final Matches _matches;
        private final String _ruleName;
        private final AceKey key;
        private Map<Class<? extends Augmentation<Ace>>, Augmentation<Ace>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        AceImpl(AceBuilder base) {
            this.key = base.key() != null ? base.key() : new AceKey(base.getRuleName());
            this._ruleName = this.key.getRuleName();
            this._aceOperData = base.getAceOperData();
            this._actions = base.getActions();
            this._matches = base.getMatches();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Ace> getImplementedInterface() {
            return Ace.class;
        }

        @Override
        public AceKey key() {
            return this.key;
        }

        @Override
        public AceOperData getAceOperData() {
            return this._aceOperData;
        }

        @Override
        public Actions getActions() {
            return this._actions;
        }

        @Override
        public Matches getMatches() {
            return this._matches;
        }

        @Override
        public String getRuleName() {
            return this._ruleName;
        }

        public <E$$ extends Augmentation<Ace>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._aceOperData);
            result = 31 * result + Objects.hashCode(this._actions);
            result = 31 * result + Objects.hashCode(this._matches);
            result = 31 * result + Objects.hashCode(this._ruleName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ace.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ace other = (Ace)obj;
            if (!Objects.equals(this._aceOperData, other.getAceOperData())) {
                return false;
            }
            if (!Objects.equals(this._actions, other.getActions())) {
                return false;
            }
            if (!Objects.equals(this._matches, other.getMatches())) {
                return false;
            }
            if (!Objects.equals(this._ruleName, other.getRuleName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AceImpl otherImpl = (AceImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ace>>, Augmentation<Ace>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Ace");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_aceOperData", (Object)this._aceOperData);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_actions", (Object)this._actions);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_matches", (Object)this._matches);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ruleName", (Object)this._ruleName);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

