/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.AceIp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.ace.ip.AceIpVersion;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Dscp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclIpHeaderFields;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclTransportHeaderFields;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.DestinationPortRange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.acl.transport.header.fields.SourcePortRange;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AceIpBuilder
implements Builder<AceIp> {
    private AceIpVersion _aceIpVersion;
    private DestinationPortRange _destinationPortRange;
    private Dscp _dscp;
    private Short _protocol;
    private SourcePortRange _sourcePortRange;
    Map<Class<? extends Augmentation<AceIp>>, Augmentation<AceIp>> augmentation = Collections.emptyMap();

    public AceIpBuilder() {
    }

    public AceIpBuilder(AclIpHeaderFields arg) {
        this._dscp = arg.getDscp();
        this._protocol = arg.getProtocol();
        this._sourcePortRange = arg.getSourcePortRange();
        this._destinationPortRange = arg.getDestinationPortRange();
    }

    public AceIpBuilder(AclTransportHeaderFields arg) {
        this._sourcePortRange = arg.getSourcePortRange();
        this._destinationPortRange = arg.getDestinationPortRange();
    }

    public AceIpBuilder(AceIp base) {
        Map aug;
        this._aceIpVersion = base.getAceIpVersion();
        this._destinationPortRange = base.getDestinationPortRange();
        this._dscp = base.getDscp();
        this._protocol = base.getProtocol();
        this._sourcePortRange = base.getSourcePortRange();
        if (base instanceof AceIpImpl) {
            AceIpImpl impl = (AceIpImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AceIp>>, Augmentation<AceIp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AceIp>>, Augmentation<AceIp>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AclTransportHeaderFields) {
            this._sourcePortRange = ((AclTransportHeaderFields)arg).getSourcePortRange();
            this._destinationPortRange = ((AclTransportHeaderFields)arg).getDestinationPortRange();
            isValidArg = true;
        }
        if (arg instanceof AclIpHeaderFields) {
            this._dscp = ((AclIpHeaderFields)arg).getDscp();
            this._protocol = ((AclIpHeaderFields)arg).getProtocol();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclTransportHeaderFields, org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclIpHeaderFields]");
    }

    public AceIpVersion getAceIpVersion() {
        return this._aceIpVersion;
    }

    public DestinationPortRange getDestinationPortRange() {
        return this._destinationPortRange;
    }

    public Dscp getDscp() {
        return this._dscp;
    }

    public Short getProtocol() {
        return this._protocol;
    }

    public SourcePortRange getSourcePortRange() {
        return this._sourcePortRange;
    }

    public <E$$ extends Augmentation<AceIp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AceIpBuilder setAceIpVersion(AceIpVersion value) {
        this._aceIpVersion = value;
        return this;
    }

    public AceIpBuilder setDestinationPortRange(DestinationPortRange value) {
        this._destinationPortRange = value;
        return this;
    }

    public AceIpBuilder setDscp(Dscp value) {
        this._dscp = value;
        return this;
    }

    private static void checkProtocolRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (int)value);
    }

    public AceIpBuilder setProtocol(Short value) {
        if (value != null) {
            AceIpBuilder.checkProtocolRange(value);
        }
        this._protocol = value;
        return this;
    }

    public AceIpBuilder setSourcePortRange(SourcePortRange value) {
        this._sourcePortRange = value;
        return this;
    }

    public AceIpBuilder addAugmentation(Class<? extends Augmentation<AceIp>> augmentationType, Augmentation<AceIp> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AceIp>>, Augmentation<AceIp>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AceIpBuilder removeAugmentation(Class<? extends Augmentation<AceIp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AceIp build() {
        return new AceIpImpl(this);
    }

    private static final class AceIpImpl
    implements AceIp {
        private final AceIpVersion _aceIpVersion;
        private final DestinationPortRange _destinationPortRange;
        private final Dscp _dscp;
        private final Short _protocol;
        private final SourcePortRange _sourcePortRange;
        private Map<Class<? extends Augmentation<AceIp>>, Augmentation<AceIp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        AceIpImpl(AceIpBuilder base) {
            this._aceIpVersion = base.getAceIpVersion();
            this._destinationPortRange = base.getDestinationPortRange();
            this._dscp = base.getDscp();
            this._protocol = base.getProtocol();
            this._sourcePortRange = base.getSourcePortRange();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<AceIp> getImplementedInterface() {
            return AceIp.class;
        }

        @Override
        public AceIpVersion getAceIpVersion() {
            return this._aceIpVersion;
        }

        public DestinationPortRange getDestinationPortRange() {
            return this._destinationPortRange;
        }

        public Dscp getDscp() {
            return this._dscp;
        }

        public Short getProtocol() {
            return this._protocol;
        }

        public SourcePortRange getSourcePortRange() {
            return this._sourcePortRange;
        }

        public <E$$ extends Augmentation<AceIp>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._aceIpVersion);
            result = 31 * result + Objects.hashCode(this._destinationPortRange);
            result = 31 * result + Objects.hashCode(this._dscp);
            result = 31 * result + Objects.hashCode(this._protocol);
            result = 31 * result + Objects.hashCode(this._sourcePortRange);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AceIp.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AceIp other = (AceIp)obj;
            if (!Objects.equals(this._aceIpVersion, other.getAceIpVersion())) {
                return false;
            }
            if (!Objects.equals(this._destinationPortRange, other.getDestinationPortRange())) {
                return false;
            }
            if (!Objects.equals(this._dscp, other.getDscp())) {
                return false;
            }
            if (!Objects.equals(this._protocol, other.getProtocol())) {
                return false;
            }
            if (!Objects.equals(this._sourcePortRange, other.getSourcePortRange())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AceIpImpl otherImpl = (AceIpImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AceIp>>, Augmentation<AceIp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"AceIp");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_aceIpVersion", (Object)this._aceIpVersion);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_destinationPortRange", (Object)this._destinationPortRange);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dscp", (Object)this._dscp);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_protocol", (Object)this._protocol);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sourcePortRange", (Object)this._sourcePortRange);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

