/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.ace.ip.ace.ip.version;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.ace.ip.ace.ip.version.AceIpv6;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6FlowLabel;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclIpv6HeaderFields;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AceIpv6Builder
implements Builder<AceIpv6> {
    private Ipv6Prefix _destinationIpv6Network;
    private Ipv6FlowLabel _flowLabel;
    private Ipv6Prefix _sourceIpv6Network;
    Map<Class<? extends Augmentation<AceIpv6>>, Augmentation<AceIpv6>> augmentation = Collections.emptyMap();

    public AceIpv6Builder() {
    }

    public AceIpv6Builder(AclIpv6HeaderFields arg) {
        this._destinationIpv6Network = arg.getDestinationIpv6Network();
        this._sourceIpv6Network = arg.getSourceIpv6Network();
        this._flowLabel = arg.getFlowLabel();
    }

    public AceIpv6Builder(AceIpv6 base) {
        Map aug;
        this._destinationIpv6Network = base.getDestinationIpv6Network();
        this._flowLabel = base.getFlowLabel();
        this._sourceIpv6Network = base.getSourceIpv6Network();
        if (base instanceof AceIpv6Impl) {
            AceIpv6Impl impl = (AceIpv6Impl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AceIpv6>>, Augmentation<AceIpv6>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AceIpv6>>, Augmentation<AceIpv6>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AclIpv6HeaderFields) {
            this._destinationIpv6Network = ((AclIpv6HeaderFields)arg).getDestinationIpv6Network();
            this._sourceIpv6Network = ((AclIpv6HeaderFields)arg).getSourceIpv6Network();
            this._flowLabel = ((AclIpv6HeaderFields)arg).getFlowLabel();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclIpv6HeaderFields]");
    }

    public Ipv6Prefix getDestinationIpv6Network() {
        return this._destinationIpv6Network;
    }

    public Ipv6FlowLabel getFlowLabel() {
        return this._flowLabel;
    }

    public Ipv6Prefix getSourceIpv6Network() {
        return this._sourceIpv6Network;
    }

    public <E$$ extends Augmentation<AceIpv6>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AceIpv6Builder setDestinationIpv6Network(Ipv6Prefix value) {
        this._destinationIpv6Network = value;
        return this;
    }

    public AceIpv6Builder setFlowLabel(Ipv6FlowLabel value) {
        this._flowLabel = value;
        return this;
    }

    public AceIpv6Builder setSourceIpv6Network(Ipv6Prefix value) {
        this._sourceIpv6Network = value;
        return this;
    }

    public AceIpv6Builder addAugmentation(Class<? extends Augmentation<AceIpv6>> augmentationType, Augmentation<AceIpv6> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AceIpv6>>, Augmentation<AceIpv6>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AceIpv6Builder removeAugmentation(Class<? extends Augmentation<AceIpv6>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AceIpv6 build() {
        return new AceIpv6Impl(this);
    }

    private static final class AceIpv6Impl
    implements AceIpv6 {
        private final Ipv6Prefix _destinationIpv6Network;
        private final Ipv6FlowLabel _flowLabel;
        private final Ipv6Prefix _sourceIpv6Network;
        private Map<Class<? extends Augmentation<AceIpv6>>, Augmentation<AceIpv6>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        AceIpv6Impl(AceIpv6Builder base) {
            this._destinationIpv6Network = base.getDestinationIpv6Network();
            this._flowLabel = base.getFlowLabel();
            this._sourceIpv6Network = base.getSourceIpv6Network();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<AceIpv6> getImplementedInterface() {
            return AceIpv6.class;
        }

        public Ipv6Prefix getDestinationIpv6Network() {
            return this._destinationIpv6Network;
        }

        public Ipv6FlowLabel getFlowLabel() {
            return this._flowLabel;
        }

        public Ipv6Prefix getSourceIpv6Network() {
            return this._sourceIpv6Network;
        }

        public <E$$ extends Augmentation<AceIpv6>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._destinationIpv6Network);
            result = 31 * result + Objects.hashCode(this._flowLabel);
            result = 31 * result + Objects.hashCode(this._sourceIpv6Network);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AceIpv6.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AceIpv6 other = (AceIpv6)obj;
            if (!Objects.equals(this._destinationIpv6Network, other.getDestinationIpv6Network())) {
                return false;
            }
            if (!Objects.equals(this._flowLabel, other.getFlowLabel())) {
                return false;
            }
            if (!Objects.equals(this._sourceIpv6Network, other.getSourceIpv6Network())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AceIpv6Impl otherImpl = (AceIpv6Impl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AceIpv6>>, Augmentation<AceIpv6>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"AceIpv6");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_destinationIpv6Network", (Object)this._destinationIpv6Network);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_flowLabel", (Object)this._flowLabel);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sourceIpv6Network", (Object)this._sourceIpv6Network);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

