/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.encrypt.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.RandomStringUtils;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.aaa.encrypt.impl.MdsalUtils;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.AaaEncryptServiceConfig;
import org.opendaylight.yang.gen.v1.config.aaa.authn.encrypt.service.config.rev160915.AaaEncryptServiceConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Deprecated
public class AAAEncryptionServiceImpl
implements AAAEncryptionService {
    private static final Logger LOG = LoggerFactory.getLogger(AAAEncryptionServiceImpl.class);
    private static final String DEFAULT_CONFIG_FILE_PATH = "etc" + File.separator + "opendaylight" + File.separator + "datastore" + File.separator + "initial" + File.separator + "config" + File.separator + "aaa-encrypt-service-config.xml";
    private final SecretKey key;
    private final IvParameterSpec ivspec;
    private final Cipher encryptCipher;
    private final Cipher decryptCipher;

    public AAAEncryptionServiceImpl(AaaEncryptServiceConfig encrySrvConfig, DataBroker dataBroker) {
        SecretKey tempKey = null;
        IvParameterSpec tempIvSpec = null;
        if (encrySrvConfig.getEncryptSalt() == null) {
            throw new IllegalArgumentException("null encryptSalt in AaaEncryptServiceConfig: " + encrySrvConfig.toString());
        }
        if (encrySrvConfig.getEncryptKey() != null && encrySrvConfig.getEncryptKey().isEmpty()) {
            LOG.debug("Set the Encryption service password and encrypt salt");
            String newPwd = RandomStringUtils.random((int)encrySrvConfig.getPasswordLength(), (boolean)true, (boolean)true);
            SecureRandom random = new SecureRandom();
            byte[] salt = new byte[16];
            ((Random)random).nextBytes(salt);
            String encodedSalt = Base64.getEncoder().encodeToString(salt);
            encrySrvConfig = new AaaEncryptServiceConfigBuilder(encrySrvConfig).setEncryptKey(newPwd).setEncryptSalt(encodedSalt).build();
            AAAEncryptionServiceImpl.updateEncrySrvConfig(newPwd, encodedSalt);
            AAAEncryptionServiceImpl.initializeConfigDataTree(encrySrvConfig, dataBroker);
        }
        byte[] enryptionKeySalt = Base64.getDecoder().decode(encrySrvConfig.getEncryptSalt());
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encrySrvConfig.getEncryptMethod());
            PBEKeySpec spec = new PBEKeySpec(encrySrvConfig.getEncryptKey().toCharArray(), enryptionKeySalt, encrySrvConfig.getEncryptIterationCount(), encrySrvConfig.getEncryptKeyLength());
            tempKey = keyFactory.generateSecret(spec);
            tempKey = new SecretKeySpec(tempKey.getEncoded(), encrySrvConfig.getEncryptType());
            tempIvSpec = new IvParameterSpec(enryptionKeySalt);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOG.error("Failed to initialize secret key", (Throwable)e);
        }
        this.key = tempKey;
        this.ivspec = tempIvSpec;
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(encrySrvConfig.getCipherTransforms());
            cipher.init(1, (Key)this.key, this.ivspec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            LOG.error("Failed to create encrypt cipher.", (Throwable)e);
        }
        this.encryptCipher = cipher;
        cipher = null;
        try {
            cipher = Cipher.getInstance(encrySrvConfig.getCipherTransforms());
            cipher.init(2, (Key)this.key, this.ivspec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            LOG.error("Failed to create decrypt cipher.", (Throwable)e);
        }
        this.decryptCipher = cipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encrypt(String data) {
        if (this.key == null) {
            LOG.warn("Encryption Key is NULL, will not encrypt data.");
            return data;
        }
        try {
            Cipher cipher = this.encryptCipher;
            synchronized (cipher) {
                byte[] cryptobytes = this.encryptCipher.doFinal(data.getBytes(Charset.defaultCharset()));
                String cryptostring = DatatypeConverter.printBase64Binary((byte[])cryptobytes);
                return cryptostring;
            }
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            LOG.error("Failed to encrypt data.", (Throwable)e);
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] data) {
        if (this.key == null) {
            LOG.warn("Encryption Key is NULL, will not encrypt data.");
            return data;
        }
        try {
            Cipher cipher = this.encryptCipher;
            synchronized (cipher) {
                return this.encryptCipher.doFinal(data);
            }
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            LOG.error("Failed to encrypt data.", (Throwable)e);
            return data;
        }
    }

    public String decrypt(String encryptedData) {
        if (this.key == null || encryptedData == null || encryptedData.length() == 0) {
            LOG.warn("String {} was not decrypted.", (Object)encryptedData);
            return encryptedData;
        }
        try {
            byte[] cryptobytes = DatatypeConverter.parseBase64Binary((String)encryptedData);
            byte[] clearbytes = this.decryptCipher.doFinal(cryptobytes);
            return new String(clearbytes, Charset.defaultCharset());
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            LOG.error("Failed to decrypt encoded data", (Throwable)e);
            return encryptedData;
        }
    }

    public byte[] decrypt(byte[] encryptedData) {
        if (encryptedData == null) {
            LOG.warn("encryptedData is null.");
            return encryptedData;
        }
        try {
            return this.decryptCipher.doFinal(encryptedData);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            LOG.error("Failed to decrypt encoded data", (Throwable)e);
            return encryptedData;
        }
    }

    private static void updateEncrySrvConfig(String newPwd, String newSalt) {
        try {
            String encryptKeyTag = "encrypt-key";
            String encryptSaltTag = "encrypt-salt";
            LOG.debug("Update encryption service config file");
            File configFile = new File(DEFAULT_CONFIG_FILE_PATH);
            if (configFile.exists()) {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(configFile);
                Node keyNode = doc.getElementsByTagName("encrypt-key").item(0);
                keyNode.setTextContent(newPwd);
                Node salt = doc.getElementsByTagName("encrypt-salt").item(0);
                salt.setTextContent(newSalt);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File(DEFAULT_CONFIG_FILE_PATH));
                transformer.transform(source, result);
            } else {
                LOG.warn("The encryption service config file does not exist {}", (Object)DEFAULT_CONFIG_FILE_PATH);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            LOG.error("Error while updating the encryption service config file", (Throwable)e);
        }
    }

    private static void initializeConfigDataTree(AaaEncryptServiceConfig encrySrvConfig, DataBroker dataBroker) {
        if (MdsalUtils.read(dataBroker, LogicalDatastoreType.CONFIGURATION, MdsalUtils.getEncryptionSrvConfigIid()) == null) {
            MdsalUtils.initalizeDatastore(LogicalDatastoreType.CONFIGURATION, dataBroker, MdsalUtils.getEncryptionSrvConfigIid(), encrySrvConfig);
        }
    }
}

