/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.tm.impl.geronimo;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;
import org.ops4j.pax.transx.tm.LastResource;
import org.ops4j.pax.transx.tm.NamedResource;
import org.ops4j.pax.transx.tm.ResourceFactory;
import org.ops4j.pax.transx.tm.impl.AbstractTransactionManagerWrapper;

public class TransactionManagerWrapper
extends AbstractTransactionManagerWrapper<GeronimoTransactionManager> {
    protected final Map<String, ResourceFactory> resources = new HashMap<String, ResourceFactory>();

    public TransactionManagerWrapper(GeronimoTransactionManager geronimoTransactionManager) {
        super(geronimoTransactionManager);
    }

    public boolean isLastResourceCommitSupported() {
        return true;
    }

    public void registerResource(final ResourceFactory resource) {
        ((GeronimoTransactionManager)this.tm).registerNamedXAResourceFactory(new NamedXAResourceFactory(){
            private Map<NamedXAResource, NamedResource> resources = new IdentityHashMap<NamedXAResource, NamedResource>();

            @Override
            public String getName() {
                return resource.getName();
            }

            @Override
            public NamedXAResource getNamedXAResource() throws SystemException {
                NamedResource res = resource.create();
                WrapperNamedXAResource nres = new WrapperNamedXAResource((XAResource)res, res.getName());
                this.resources.put(nres, res);
                return nres;
            }

            @Override
            public void returnNamedXAResource(NamedXAResource namedXAResource) {
                NamedResource nres = this.resources.remove(namedXAResource);
                if (nres == null) {
                    throw new IllegalStateException("Unexpected call to returnNamedXAResource");
                }
                resource.release(nres);
            }
        });
        this.resources.put(resource.getName(), resource);
    }

    public void unregisterResource(String name) {
        this.resources.remove(name);
        ((GeronimoTransactionManager)this.tm).unregisterNamedXAResourceFactory(name);
    }

    public ResourceFactory getResource(String name) {
        return this.resources.get(name);
    }

    @Override
    protected AbstractTransactionManagerWrapper.TransactionWrapper doCreateTransactionWrapper(Transaction tx) {
        return new GeronimoTransactionWrapper(tx);
    }

    class GeronimoTransactionWrapper
    extends AbstractTransactionManagerWrapper.TransactionWrapper {
        LastResource last;

        GeronimoTransactionWrapper(Transaction transaction) {
            super(transaction);
        }

        @Override
        public void commit() throws Exception {
            if (this.last != null) {
                super.enlistResource((NamedResource)this.last);
            }
            super.commit();
        }

        @Override
        public void rollback() throws Exception {
            if (this.last != null) {
                super.enlistResource((NamedResource)this.last);
            }
            super.rollback();
        }

        @Override
        public void enlistResource(NamedResource xares) throws Exception {
            if (xares instanceof LastResource) {
                if (this.last != null) {
                    throw new IllegalStateException("Can not enlist two LastResource instances");
                }
                this.last = (LastResource)xares;
            } else {
                super.enlistResource(xares);
            }
        }

        @Override
        public void delistResource(NamedResource xares, int flags) throws Exception {
            super.delistResource(xares, flags);
        }
    }
}

