/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum ErrorTagType implements Enumeration
{
    InUse(0, "in-use"),
    InvalidValue(1, "invalid-value"),
    TooBig(2, "too-big"),
    MissingAttribute(3, "missing-attribute"),
    BadAttribute(4, "bad-attribute"),
    UnknownAttribute(5, "unknown-attribute"),
    MissingElement(6, "missing-element"),
    BadElement(7, "bad-element"),
    UnknownElement(8, "unknown-element"),
    UnknownNamespace(9, "unknown-namespace"),
    AccessDenied(10, "access-denied"),
    LockDenied(11, "lock-denied"),
    ResourceDenied(12, "resource-denied"),
    RollbackFailed(13, "rollback-failed"),
    DataExists(14, "data-exists"),
    DataMissing(15, "data-missing"),
    OperationNotSupported(16, "operation-not-supported"),
    OperationFailed(17, "operation-failed"),
    PartialOperation(18, "partial-operation"),
    MalformedMessage(19, "malformed-message");

    private static final Map<String, ErrorTagType> NAME_MAP;
    private static final Map<Integer, ErrorTagType> VALUE_MAP;
    private final String name;
    private final int value;

    private ErrorTagType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<ErrorTagType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static ErrorTagType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (ErrorTagType enumItem : ErrorTagType.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

