/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.get.config.input;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.get.config.input.Source;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.get.config.input.source.ConfigSource;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SourceBuilder
implements Builder<Source> {
    private ConfigSource _configSource;
    Map<Class<? extends Augmentation<Source>>, Augmentation<Source>> augmentation = Collections.emptyMap();

    public SourceBuilder() {
    }

    public SourceBuilder(Source base) {
        Map aug;
        this._configSource = base.getConfigSource();
        if (base instanceof SourceImpl) {
            SourceImpl impl = (SourceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>(aug);
        }
    }

    public ConfigSource getConfigSource() {
        return this._configSource;
    }

    public <E$$ extends Augmentation<Source>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SourceBuilder setConfigSource(ConfigSource value) {
        this._configSource = value;
        return this;
    }

    public SourceBuilder addAugmentation(Class<? extends Augmentation<Source>> augmentationType, Augmentation<Source> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SourceBuilder removeAugmentation(Class<? extends Augmentation<Source>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Source build() {
        return new SourceImpl(this);
    }

    private static final class SourceImpl
    implements Source {
        private final ConfigSource _configSource;
        private Map<Class<? extends Augmentation<Source>>, Augmentation<Source>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SourceImpl(SourceBuilder base) {
            this._configSource = base.getConfigSource();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Source> getImplementedInterface() {
            return Source.class;
        }

        @Override
        public ConfigSource getConfigSource() {
            return this._configSource;
        }

        public <E$$ extends Augmentation<Source>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._configSource);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Source.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Source other = (Source)obj;
            if (!Objects.equals(this._configSource, other.getConfigSource())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SourceImpl otherImpl = (SourceImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Source>>, Augmentation<Source>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Source");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_configSource", (Object)this._configSource);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

