/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.netconf.databrokerlistener;

import com.raisecom.zerotouch.kafka.KafkaProducer;
import com.raisecom.zerotouch.util.PropertiesReader;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.json.JSONObject;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.callhome.device.status.rev170112.Device1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.NetconfCallhomeServer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.AllowedDevices;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.callhome.server.rev161109.netconf.callhome.server.allowed.devices.Device;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallhomeChangeListener
implements DataTreeChangeListener<Device> {
    private static final Logger LOG = LoggerFactory.getLogger(CallhomeChangeListener.class);
    private static final String CALLHOME_ONLINE_TOPIC = "sdnc-inventory-callhome-online";
    private static final InstanceIdentifier<Device> ALLOWED_DEVICES_PATH = InstanceIdentifier.create(NetconfCallhomeServer.class).child(AllowedDevices.class).child(Device.class);
    private final ListenerRegistration<CallhomeChangeListener> reg;
    private final DataBroker dataBroker;

    public CallhomeChangeListener(DataBroker dataBroker) {
        this.dataBroker = dataBroker;
        this.reg = this.dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, ALLOWED_DEVICES_PATH), (DataTreeChangeListener)this);
    }

    public void destroy() {
        LOG.info("Destroy CallhomeChangeListener.");
        if (this.reg != null) {
            this.reg.close();
        }
    }

    public void onDataTreeChanged(@NonNull Collection<DataTreeModification<Device>> changes) {
        block4: for (DataTreeModification<Device> change : changes) {
            switch (change.getRootNode().getModificationType()) {
                case WRITE: 
                case SUBTREE_MODIFIED: {
                    Device device = (Device)change.getRootNode().getDataAfter();
                    Device1.DeviceStatus status = ((Device1)device.augmentation(Device1.class)).getDeviceStatus();
                    LOG.debug("{} allowed device {} {}.", new Object[]{change.getRootNode().getModificationType(), device.getUniqueId(), status});
                    if (!device.getUniqueId().contains(":") || status != Device1.DeviceStatus.FAILEDNOTALLOWED) break;
                    JSONObject message = this.callhomeOnline(device);
                    if (message == null) continue block4;
                    String msg = message.toString();
                    KafkaProducer.getInstance().sendMessage(CALLHOME_ONLINE_TOPIC, null, msg, msg);
                    break;
                }
                case DELETE: {
                    Device device = (Device)change.getRootNode().getDataBefore();
                    LOG.debug("DELETE allowed device {}.", (Object)device.getUniqueId());
                    break;
                }
            }
        }
    }

    private JSONObject callhomeOnline(Device device) {
        String[] ipAndPort;
        if (device != null && device.getUniqueId().contains(":") && (ipAndPort = device.getUniqueId().split(":")).length == 2) {
            JSONObject message = new JSONObject();
            message.put("netconf-hostip", (Object)PropertiesReader.getInstance().getLocalIp());
            message.put("ip", (Object)ipAndPort[0]);
            message.put("port", (Object)ipAndPort[1]);
            message.put("ssh-host-key", (Object)device.getSshHostKey());
            return message;
        }
        return null;
    }
}

