/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.netconf.databrokerlistener;

import com.raisecom.zerotouch.constant.NeStatus;
import com.raisecom.zerotouch.threads.NeOfflineDeleteRunnable;
import com.raisecom.zerotouch.threads.NeOnlineRunnable;
import com.raisecom.zerotouch.threads.NeTaskManager;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeConnectionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.network.topology.topology.topology.types.TopologyNetconf;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountPointChangeListener
implements DataTreeChangeListener<Node> {
    private static final Logger LOG = LoggerFactory.getLogger(MountPointChangeListener.class);
    private static final InstanceIdentifier<Topology> NETCONF_TOPO_IID = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Identifier)new TopologyKey(new TopologyId(TopologyNetconf.QNAME.getLocalName())));
    private final ListenerRegistration<MountPointChangeListener> reg;
    private final DataBroker dataBroker;
    private final DOMMountPointService domMountPointService;

    public MountPointChangeListener(DataBroker dataBroker, DOMMountPointService domMountPointService) {
        this.dataBroker = dataBroker;
        this.domMountPointService = domMountPointService;
        this.reg = this.dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)NETCONF_TOPO_IID.child(Node.class)), (DataTreeChangeListener)this);
    }

    public void destroy() {
        LOG.info("Destroy MountPointChangeListener.");
        if (this.reg != null) {
            this.reg.close();
        }
    }

    public void onDataTreeChanged(@NonNull Collection<DataTreeModification<Node>> changes) {
        for (DataTreeModification<Node> change : changes) {
            InstanceIdentifier identifier = change.getRootPath().getRootIdentifier();
            String netconfId = this.parseNodeId((InstanceIdentifier<Node>)identifier);
            if (null == netconfId) continue;
            this.handleRootNode((DataObjectModification<Node>)change.getRootNode(), netconfId);
        }
    }

    private String parseNodeId(InstanceIdentifier<Node> identifier) {
        NodeKey nodeKey = (NodeKey)identifier.firstKeyOf(Node.class);
        if (nodeKey == null) {
            return null;
        }
        return nodeKey.getNodeId().getValue();
    }

    private void handleRootNode(DataObjectModification<Node> rootNode, String netconfId) {
        switch (rootNode.getModificationType()) {
            case WRITE: 
            case SUBTREE_MODIFIED: {
                NetconfNode netconfNode = (NetconfNode)((Node)rootNode.getDataAfter()).augmentation(NetconfNode.class);
                NetconfNodeConnectionStatus.ConnectionStatus status = netconfNode.getConnectionStatus();
                if (NetconfNodeConnectionStatus.ConnectionStatus.Connected.equals((Object)status)) {
                    NeTaskManager.getInstance().addTask(new NeOnlineRunnable(netconfId, netconfNode, this.domMountPointService));
                    break;
                }
                if (NetconfNodeConnectionStatus.ConnectionStatus.Connecting.equals((Object)status)) {
                    NeTaskManager.getInstance().addTask(new NeOfflineDeleteRunnable(netconfId, NeStatus.CONNECTING, netconfNode.getHost().stringValue(), netconfNode.getPort().getValue()));
                    break;
                }
                LOG.warn("Unhandled modification {} {}!", (Object)status, (Object)netconfId);
                break;
            }
            case DELETE: {
                NetconfNode netconfNode = (NetconfNode)((Node)rootNode.getDataBefore()).augmentation(NetconfNode.class);
                NeTaskManager.getInstance().addTask(new NeOfflineDeleteRunnable(netconfId, NeStatus.DELETE, netconfNode.getHost().stringValue(), netconfNode.getPort().getValue()));
                break;
            }
        }
    }
}

