/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.restclient;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfRestClient {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfRestClient.class);
    private static final String ERROR_CODE = "errorCode";
    private static final String ERROR_INFO = "errorInfo";
    private static final String ADMIN = "admin";

    private NetconfRestClient() {
    }

    public static String get(String url) {
        LOG.info("Get url={}", (Object)url);
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = client.target(url);
        webTarget.request(new String[]{"application/json", "text/plain"});
        Response response = webTarget.request().get();
        String res = (String)response.readEntity(String.class);
        LOG.info("Status={}. Body={}", (Object)response.getStatus(), (Object)res);
        return res;
    }

    public static int getFromRestConf(String url) {
        LOG.info("Get url = {}", (Object)url);
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = client.target(url);
        webTarget.register((Object)HttpAuthenticationFeature.basicBuilder().credentials(ADMIN, ADMIN).build());
        webTarget.request(new String[]{"application/json", "text/plain"});
        Response response = webTarget.request().get();
        String res = (String)response.readEntity(String.class);
        LOG.info("Status={}. Body={}", (Object)response.getStatus(), (Object)res);
        return response.getStatus();
    }

    public static JSONObject post(String url, String body) {
        LOG.info("Post url={}, body={}", (Object)url, (Object)body);
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = client.target(url);
        webTarget.request(new String[]{"application/json"});
        Response response = webTarget.request().post(Entity.entity((Object)body, (String)"application/json"));
        JSONObject res = new JSONObject();
        res.put(ERROR_CODE, response.getStatus());
        res.put(ERROR_INFO, response.readEntity(String.class));
        LOG.info("{}", (Object)res);
        return res;
    }
}

