/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.threads;

import com.raisecom.zerotouch.constant.NeStatus;
import com.raisecom.zerotouch.kafka.KafkaProducer;
import com.raisecom.zerotouch.rabbitmq.RabbitMQProducer;
import com.raisecom.zerotouch.util.PropertiesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NeRunnable
implements Runnable {
    protected final String netconfId;
    protected final NeStatus status;
    protected final String host;
    protected final int port;
    protected final String desc;
    protected static final String NODE_ID = "node-id";
    protected static final String CONNECTION_STATUS = "netconf-node-topology:connection-status";
    protected static final String NETCONF_ONLINE = "netconf_online";
    protected static final String NODE = "node";
    private static final Logger LOG = LoggerFactory.getLogger(NeRunnable.class);

    public NeRunnable(String netconfId, NeStatus status, String host, int port) {
        this.netconfId = netconfId;
        this.status = status;
        this.host = host;
        this.port = port;
        this.desc = String.format("%s %s %s %s task", netconfId, status.getName(), host, port);
    }

    public String getNetconfId() {
        return this.netconfId;
    }

    public NeStatus getStatus() {
        return this.status;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    protected void sendMessage(String topic, String message) {
        switch (PropertiesReader.getInstance().getMsgMiddleware()) {
            case KAFKA: {
                KafkaProducer.getInstance().sendMessage(topic, null, message, this.desc);
                break;
            }
            case RABBIT_MQ: {
                RabbitMQProducer.getInstance().sendMessage(topic, message, this.desc);
                break;
            }
            default: {
                LOG.warn("Record netconf_online {}", (Object)this.desc);
            }
        }
    }

    public String toString() {
        return this.desc;
    }
}

