/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.threads;

import com.raisecom.zerotouch.threads.NeRunnable;
import com.raisecom.zerotouch.threads.NeTaskManager;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NeTaskThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(NeTaskThreadPoolExecutor.class);
    private static final int CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private static final int QUEUE_SIZE = 4096;

    public NeTaskThreadPoolExecutor() {
        super(CORE_POOL_SIZE, 2 * CORE_POOL_SIZE, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(4096), new NetconfThreadFactory());
    }

    @Override
    public void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        if (throwable != null) {
            LOG.warn("Execute {} failed! {}", (Object)runnable, (Object)throwable.getMessage());
        }
        if (runnable instanceof NeRunnable) {
            NeRunnable task = (NeRunnable)runnable;
            LOG.warn("{} is finished. Take the next.", (Object)task);
            NeTaskManager.getInstance().executeNextTask(task.getNetconfId());
        }
    }

    static final class NetconfThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private static final String NAME_PREFIX = "online-pool-thread-%d";

        public NetconfThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(this.group, runnable, String.format(NAME_PREFIX, this.threadNumber.getAndIncrement()), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

