/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;

public final class IpAddressMatcher {
    private static final Pattern IPV4_PATTERN = Pattern.compile("((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\\.){3}" + "(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])" + "(%[\\p{N}\\p{L}]+)?");
    private static final Pattern IPV6_PATTERN_1 = Pattern.compile("((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}" + "((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|" + "(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}" + "(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))" + "(%[\\p{N}\\p{L}]+)?");
    private static final Pattern IPV6_PATTERN_2 = Pattern.compile("(([^:]+:){6}(([^:]+:[^:]+)|(.*\\..*)))|" + "((([^:]+:)*[^:]+)?::(([^:]+:)*[^:]+)?)" + "(%.+)?");
    private static final List<Pattern> PATTERN_LIST = ImmutableList.of((Object)IPV4_PATTERN, (Object)IPV6_PATTERN_1, (Object)IPV6_PATTERN_2);
    private static final int MAX_PORT = 65535;

    private IpAddressMatcher() {
    }

    public static boolean isIpValid(String input) {
        if (input == null) {
            return false;
        }
        for (Pattern pattern : PATTERN_LIST) {
            if (!pattern.matcher(input).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean isIpv4(String input) {
        if (input == null) {
            return false;
        }
        return IPV4_PATTERN.matcher(input).matches();
    }

    public static boolean isIpv6(String input) {
        if (input == null) {
            return false;
        }
        return IPV6_PATTERN_1.matcher(input).matches() || IPV6_PATTERN_2.matcher(input).matches();
    }

    public static boolean isPortValid(String input) {
        if (input != null) {
            try {
                int port = Integer.parseInt(input);
                return IpAddressMatcher.isPortInRange(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isPortInRange(int port) {
        return port > 0 && port <= 65535;
    }
}

