/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.util;

import java.util.Properties;

public final class KaConsumerProp {
    private String autoCommitInterval;
    private String enableAutoCommit;
    private String sessionTimeout;
    private String keyDeserializer;
    private String valueDeserializer;

    private KaConsumerProp(KaConsumerPropBuilder builder) {
        this.autoCommitInterval = builder.autoCommitInterval;
        this.enableAutoCommit = builder.enableAutoCommit;
        this.sessionTimeout = builder.sessionTimeout;
        this.keyDeserializer = builder.keyDeserializer;
        this.valueDeserializer = builder.valueDeserializer;
    }

    public Properties toProperties(String kafkaServers, String groupId) {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", kafkaServers);
        properties.setProperty("group", groupId);
        properties.setProperty("auto.commit.interval.ms", this.autoCommitInterval);
        properties.setProperty("enable.auto.commit", this.enableAutoCommit);
        properties.setProperty("session.timeout.ms", this.sessionTimeout);
        properties.setProperty("key.deserializer", this.keyDeserializer);
        properties.setProperty("value.deserializer", this.valueDeserializer);
        return properties;
    }

    public static class KaConsumerPropBuilder {
        private String autoCommitInterval;
        private final String enableAutoCommit;
        private String sessionTimeout;
        private String keyDeserializer;
        private String valueDeserializer;

        public KaConsumerPropBuilder(String enableAutoCommit) {
            this.enableAutoCommit = enableAutoCommit;
        }

        public KaConsumerPropBuilder autoCommitInterval(String autoCommitInterval) {
            this.autoCommitInterval = autoCommitInterval;
            return this;
        }

        public KaConsumerPropBuilder sessionTimeout(String sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public KaConsumerPropBuilder keyDeserializer(String keyDeserializer) {
            this.keyDeserializer = keyDeserializer;
            return this;
        }

        public KaConsumerPropBuilder valueDeserializer(String valueDeserializer) {
            this.valueDeserializer = valueDeserializer;
            return this;
        }

        public KaConsumerProp build() {
            return new KaConsumerProp(this);
        }
    }
}

