/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.util;

import com.raisecom.zerotouch.constant.MsgMiddleware;
import com.raisecom.zerotouch.constant.NotificationsMode;
import com.raisecom.zerotouch.constant.StartUpMode;
import com.raisecom.zerotouch.util.KaConsumerProp;
import com.raisecom.zerotouch.util.KaProducerProp;
import com.raisecom.zerotouch.util.Subscription;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesReader {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesReader.class);
    private final StartUpMode startUpMode;
    private final String clusterHost;
    private final String clusterPort;
    private String localIp;
    private final MsgMiddleware msgMiddleware;
    private final String mspSysmng;
    private final String mspGlobal;
    private final String defaultKafkaServers;
    private final KaProducerProp kaProducerProp;
    private final KaConsumerProp kaConsumerProp;
    private final String defaultRabbitMqServer;
    private final String defaultRabbitMqUsr;
    private final String defaultRabbitMqPwd;
    private final boolean callHomeGlobalEnable;
    private final String callHomeUsr;
    private final List<String> callHomePwds;
    private final NotificationsMode notificationsMode;
    private final boolean rcEquipmentEnable;
    private final Subscription subscription;

    public static PropertiesReader getInstance() {
        return PropertiesReaderHolder.INSTANCE;
    }

    private PropertiesReader() {
        String fileName = System.getProperty("user.dir") + File.separator + "etc" + File.separator + "netconf.properties";
        LOG.info("Path of netconf.properties = {}", (Object)fileName);
        Properties properties = new Properties();
        try (FileInputStream fio = new FileInputStream(fileName);){
            properties.load(fio);
        }
        catch (IOException e) {
            LOG.error("Load netconf.properties failed! {}", (Object)e.getMessage());
            throw new IllegalStateException("Load/Parse netconf.properties failed!", e);
        }
        this.startUpMode = StartUpMode.of(properties.getProperty("mode"));
        this.clusterHost = properties.getProperty("cluster.host");
        this.clusterPort = properties.getProperty("cluster.port");
        this.mspSysmng = properties.getProperty("msp.path.system");
        this.mspGlobal = properties.getProperty("msp.path.global");
        this.msgMiddleware = MsgMiddleware.of(properties.getProperty("message.middleware"));
        this.defaultKafkaServers = properties.getProperty("bootstrap.servers");
        this.kaProducerProp = new KaProducerProp.KaProducerPropBuilder(properties.getProperty("acks")).retries(properties.getProperty("retries")).batchSize(properties.getProperty("batch.size")).lingerMs(properties.getProperty("linger.ms")).bufferMemory(properties.getProperty("buffer.memory")).keySerializer(properties.getProperty("key.serializer")).valueSerializer(properties.getProperty("value.serializer")).build();
        this.kaConsumerProp = new KaConsumerProp.KaConsumerPropBuilder(properties.getProperty("enable.auto.commit")).autoCommitInterval(properties.getProperty("auto.commit.interval.ms")).sessionTimeout(properties.getProperty("session.timeout.ms")).keyDeserializer(properties.getProperty("key.deserializer")).valueDeserializer(properties.getProperty("value.deserializer")).build();
        this.defaultRabbitMqServer = properties.getProperty("rabbitMQ.server");
        this.defaultRabbitMqUsr = properties.getProperty("rabbitMQ.username");
        this.defaultRabbitMqPwd = properties.getProperty("rabbitMQ.password");
        this.callHomeGlobalEnable = Boolean.parseBoolean(properties.getProperty("callhome.global.config.enable"));
        this.callHomeUsr = properties.getProperty("callhome.credentials.username");
        String passwords = properties.getProperty("callhome.credentials.passwords");
        this.callHomePwds = Arrays.asList(passwords.split(","));
        this.notificationsMode = NotificationsMode.of(properties.getProperty("notification.subscription.mode"));
        this.rcEquipmentEnable = Boolean.parseBoolean(properties.getProperty("raisecom.equipment.supported"));
        this.subscription = new Subscription.SubscriptionBuilder(this.notificationsMode).build();
    }

    public String getMspSysmng() {
        return this.mspSysmng;
    }

    public String getMspGlobal() {
        return this.mspGlobal;
    }

    public StartUpMode getStartUpMode() {
        return this.startUpMode;
    }

    public String getClusterHost() {
        return this.clusterHost;
    }

    public String getClusterPort() {
        return this.clusterPort;
    }

    public String getLocalIp() {
        return this.localIp;
    }

    public void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    public boolean isCallHomeGlobalEnable() {
        return this.callHomeGlobalEnable;
    }

    public String getCallHomeUsr() {
        return this.callHomeUsr;
    }

    public List<String> getCallHomePwds() {
        return this.callHomePwds;
    }

    public MsgMiddleware getMsgMiddleware() {
        return this.msgMiddleware;
    }

    public String getDefaultKafkaServers() {
        return this.defaultKafkaServers;
    }

    public KaProducerProp getKaProducerProp() {
        return this.kaProducerProp;
    }

    public KaConsumerProp getKaConsumerProp() {
        return this.kaConsumerProp;
    }

    public String getDefaultRabbitMqServer() {
        return this.defaultRabbitMqServer;
    }

    public String getDefaultRabbitMqUsr() {
        return this.defaultRabbitMqUsr;
    }

    public String getDefaultRabbitMqPwd() {
        return this.defaultRabbitMqPwd;
    }

    public NotificationsMode getNotificationsMode() {
        return this.notificationsMode;
    }

    public boolean isRcEquipmentEnable() {
        return this.rcEquipmentEnable;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    private static final class PropertiesReaderHolder {
        private static final PropertiesReader INSTANCE = new PropertiesReader();

        private PropertiesReaderHolder() {
        }
    }
}

