/*
 * Decompiled with CFR 0.152.
 */
package com.raisecom.zerotouch.util;

import com.google.common.collect.ImmutableMap;
import com.raisecom.zerotouch.constant.NotificationsMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.sal.connect.netconf.schema.mapping.BaseSchema;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Subscription {
    private static final Logger LOG = LoggerFactory.getLogger(Subscription.class);
    private final NormalizedNode subscriptionInput;
    private final ImmutableMap<String, List<String>> noteListenerMap;

    private Subscription(SubscriptionBuilder builder) {
        this.subscriptionInput = builder.subscriptionInput;
        this.noteListenerMap = ImmutableMap.copyOf(builder.noteListenerMap.entrySet());
    }

    public NormalizedNode getSubscriptionInput() {
        return this.subscriptionInput;
    }

    public ImmutableMap<String, List<String>> getNoteListenerMap() {
        return this.noteListenerMap;
    }

    public static class SubscriptionBuilder {
        private NotificationsMode mode;
        private final Map<String, List<String>> noteListenerMap = new HashMap<String, List<String>>();
        private NormalizedNode subscriptionInput;

        public SubscriptionBuilder(NotificationsMode mode) {
            this.mode = mode;
        }

        public Subscription build() {
            Element inputElement = this.getInputElement();
            switch (this.mode) {
                case SUBSCRIBE: {
                    this.generateListeners(inputElement);
                    this.subscriptionInput = null;
                    break;
                }
                case SUBSCRIBE_DEFAULT_FILTER: {
                    this.generateListeners(inputElement);
                    this.initDefaultSubscriptionRpc(inputElement);
                    break;
                }
                default: {
                    this.subscriptionInput = null;
                }
            }
            return new Subscription(this);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Element getInputElement() {
            String defaultNodePath = System.getProperty("user.dir") + File.separator + "etc" + File.separator + "subscription.xml";
            try (FileInputStream inputStream = new FileInputStream(defaultNodePath);){
                Element element = XmlUtil.readXmlToElement((InputStream)inputStream);
                return element;
            }
            catch (IOException | SAXException ex) {
                throw new IllegalStateException("Invalid create-subscription content!", ex);
            }
        }

        private void generateListeners(Element inputElement) {
            NodeList filterList = inputElement.getElementsByTagName("filter");
            if (filterList.getLength() <= 0) {
                LOG.warn("No notification listener to register.");
                return;
            }
            if (filterList.getLength() > 1) {
                throw new IllegalArgumentException("More than one notification filter to subscribe!");
            }
            for (Node note = filterList.item(0).getFirstChild(); note != null; note = note.getNextSibling()) {
                String uri = note.getNamespaceURI();
                if (uri == null) continue;
                if (!this.noteListenerMap.containsKey(uri)) {
                    this.noteListenerMap.put(uri, new ArrayList(4));
                }
                this.noteListenerMap.get(uri).add(note.getLocalName());
            }
        }

        private void initDefaultSubscriptionRpc(Element inputElement) {
            SchemaContext schemaContext = BaseSchema.BASE_NETCONF_CTX_WITH_NOTIFICATIONS.getSchemaContext();
            Set rpcDefSet = schemaContext.getOperations();
            RpcDefinition defaultRpcDefinition = null;
            for (RpcDefinition rpcDef : rpcDefSet) {
                if (!NetconfMessageTransformUtil.CREATE_SUBSCRIPTION_RPC_QNAME.equals((Object)rpcDef.getQName())) continue;
                defaultRpcDefinition = rpcDef;
                break;
            }
            if (defaultRpcDefinition == null) {
                throw new IllegalArgumentException("No basic create-subscription rpc to use!");
            }
            NormalizedNodeResult resultHolder = new NormalizedNodeResult();
            NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
            try (XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (SchemaContext)schemaContext, (SchemaNode)defaultRpcDefinition.getInput(), (boolean)true);){
                xmlParser.traverse(new DOMSource(inputElement));
                this.subscriptionInput = resultHolder.getResult();
            }
            catch (IOException | URISyntaxException | ParserConfigurationException | XMLStreamException | SAXException e) {
                throw new IllegalStateException("Failed to create subscription.", e);
            }
        }
    }
}

