/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.dispatch.OnComplete;
import com.google.common.util.concurrent.AbstractFuture;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opendaylight.controller.remote.rpc.RemoteDOMRpcException;
import org.opendaylight.controller.remote.rpc.messages.RpcResponse;
import org.opendaylight.mdsal.dom.api.DOMRpcException;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

final class RemoteDOMRpcFuture
extends AbstractFuture<DOMRpcResult> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteDOMRpcFuture.class);
    private final QName rpcName;

    private RemoteDOMRpcFuture(QName rpcName) {
        this.rpcName = Objects.requireNonNull(rpcName, "rpcName");
    }

    public static RemoteDOMRpcFuture create(QName rpcName) {
        return new RemoteDOMRpcFuture(rpcName);
    }

    protected void failNow(Throwable error) {
        LOG.debug("Failing future {} for rpc {}", new Object[]{this, this.rpcName, error});
        this.setException(error);
    }

    protected void completeWith(Future<Object> future) {
        future.onComplete((Function1)new FutureUpdater(), ExecutionContext.Implicits$.MODULE$.global());
    }

    public DOMRpcResult get() throws InterruptedException, ExecutionException {
        try {
            return (DOMRpcResult)super.get();
        }
        catch (ExecutionException e) {
            throw RemoteDOMRpcFuture.mapException(e);
        }
    }

    public DOMRpcResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return (DOMRpcResult)super.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw RemoteDOMRpcFuture.mapException(e);
        }
    }

    private static ExecutionException mapException(ExecutionException ex) {
        Throwable cause = ex.getCause();
        if (cause instanceof DOMRpcException) {
            return ex;
        }
        return new ExecutionException(ex.getMessage(), (Throwable)((Object)new RemoteDOMRpcException("Exception during invoking RPC", ex.getCause())));
    }

    private final class FutureUpdater
    extends OnComplete<Object> {
        private FutureUpdater() {
        }

        public void onComplete(Throwable error, Object reply) {
            if (error != null) {
                RemoteDOMRpcFuture.this.failNow(error);
            } else if (reply instanceof RpcResponse) {
                RpcResponse rpcReply = (RpcResponse)reply;
                NormalizedNode<?, ?> result = rpcReply.getResultNormalizedNode();
                LOG.debug("Received response for rpc {}: result is {}", (Object)RemoteDOMRpcFuture.this.rpcName, result);
                RemoteDOMRpcFuture.this.set(new DefaultDOMRpcResult(result));
                LOG.debug("Future {} for rpc {} successfully completed", (Object)RemoteDOMRpcFuture.this, (Object)RemoteDOMRpcFuture.this.rpcName);
            } else {
                RemoteDOMRpcFuture.this.failNow(new IllegalStateException("Incorrect reply type " + reply + "from Akka"));
            }
        }
    }
}

