/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.remote.rpc.RemoteRpcProviderConfig;
import org.opendaylight.controller.remote.rpc.RpcManager;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRpcProvider
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteRpcProvider.class);
    private final DOMRpcProviderService rpcProvisionRegistry;
    private final RemoteRpcProviderConfig config;
    private final ActorSystem actorSystem;
    private final DOMRpcService rpcService;
    private ActorRef rpcManager;

    public RemoteRpcProvider(ActorSystem actorSystem, DOMRpcProviderService rpcProvisionRegistry, DOMRpcService rpcService, RemoteRpcProviderConfig config) {
        this.actorSystem = (ActorSystem)Preconditions.checkNotNull((Object)actorSystem);
        this.rpcProvisionRegistry = (DOMRpcProviderService)Preconditions.checkNotNull((Object)rpcProvisionRegistry);
        this.rpcService = (DOMRpcService)Preconditions.checkNotNull((Object)rpcService);
        this.config = (RemoteRpcProviderConfig)((Object)Preconditions.checkNotNull((Object)((Object)config)));
    }

    @Override
    public void close() {
        if (this.rpcManager != null) {
            LOG.info("Stopping RPC Manager at {}", (Object)this.rpcManager);
            this.rpcManager.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
            this.rpcManager = null;
        }
    }

    public void start() {
        LOG.info("Starting Remote RPC service...");
        this.rpcManager = this.actorSystem.actorOf(RpcManager.props(this.rpcProvisionRegistry, this.rpcService, this.config), this.config.getRpcManagerName());
        LOG.debug("RPC Manager started at {}", (Object)this.rpcManager);
    }
}

